/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domain")
@PerLookup
public class RestartDomainCommand
extends StopDomainCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private ServiceLocator habitat;
    private static final LocalStringsImpl STRINGS = new LocalStringsImpl(RestartDomainCommand.class);

    @Override
    protected void doCommand() throws CommandException {
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restartDomain.notRestartable"));
        }
        int oldServerPid = this.getServerPid();
        RemoteCLICommand cmd = new RemoteCLICommand("restart-domain", this.programOpts, this.env);
        if (this.debug != null) {
            cmd.executeAndReturnOutput(new String[]{"restart-domain", "--debug", this.debug.toString()});
        } else {
            cmd.executeAndReturnOutput(new String[]{"restart-domain"});
        }
        this.waitForRestart(oldServerPid);
        logger.info(STRINGS.get("restartDomain.success"));
    }

    @Override
    protected int dasNotRunning() throws CommandException {
        if (!this.isLocal()) {
            throw new CommandException(Strings.get("restart.dasNotRunningNoRestart"));
        }
        logger.warning(STRINGS.get("restart.dasNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getService(CLICommand.class, "start-domain", new Annotation[0]);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-domain");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.domainDirParam != null) {
            opts.add("--domaindir");
            opts.add(this.domainDirParam);
        }
        if (this.getDomainName() != null) {
            opts.add(this.getDomainName());
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }
}

