/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.StartDomainCommand;
import java.io.File;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="start-domains")
@PerLookup
public class StartDomainsCommand
extends StartDomainCommand {
    @Param(optional=true, defaultValue="false")
    private Boolean upgrade;
    @Param(optional=true, shortName="w", defaultValue="false")
    private Boolean watchdog;
    @Param(optional=true, shortName="d", defaultValue="false")
    private Boolean debug;
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName0;
    @Param(name="dry-run", shortName="n", optional=true, defaultValue="false")
    private Boolean dry_run;
    @Param(name="drop-interrupted-commands", optional=true, defaultValue="false")
    private Boolean drop_interrupted_commands;
    @Param(name="prebootcommandfile", optional=true)
    private String preBootCommand;
    @Param(name="postbootcommandfile", optional=true)
    private String postBootCommand;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        File postbootFile;
        File prebootfile;
        if (this.preBootCommand != null && !(prebootfile = new File(this.preBootCommand)).exists()) {
            throw new CommandValidationException("preboot commands file does not exist: " + prebootfile.getAbsolutePath());
        }
        if (this.postBootCommand != null && !(postbootFile = new File(this.postBootCommand)).exists()) {
            throw new CommandValidationException("postboot commands file does not exist: " + postbootFile.getAbsolutePath());
        }
    }

    @Override
    protected int executeCommand() throws CommandException {
        try {
            String[] domains;
            for (String domainName : domains = this.domainName0.split(",")) {
                this.setDomainName(domainName);
                super.initDomain();
                this.programOpts.setHostAndPort(this.getAdminAddress());
                super.executeCommand();
                logger.log(Level.FINE, "Started domain {0}", domainName);
            }
            return 0;
        }
        catch (Exception ex) {
            throw new CommandException(ex.getLocalizedMessage());
        }
    }
}

