/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jaspic.config.helper;

import com.sun.jaspic.config.delegate.MessagePolicyDelegate;
import com.sun.jaspic.config.helper.BaseAuthConfigImpl;
import com.sun.jaspic.config.helper.BaseAuthContextImpl;
import com.sun.jaspic.config.helper.EpochCarrier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.module.ClientAuthModule;

public class ClientAuthConfigImpl
extends BaseAuthConfigImpl
implements ClientAuthConfig {
    private static final AuthStatus[] validateResponseSuccessValues = new AuthStatus[]{AuthStatus.SUCCESS};
    private static final AuthStatus[] secureResponseSuccessValues = new AuthStatus[]{AuthStatus.SEND_SUCCESS};
    private Map<String, Map<Integer, ClientAuthContext>> contextMap;
    private BaseAuthContextImpl authContextHelper;

    protected ClientAuthConfigImpl(String loggerName, EpochCarrier providerEpoch, BaseAuthContextImpl acHelper, MessagePolicyDelegate mpDelegate, String layer, String appContext, CallbackHandler cbh) throws AuthException {
        super(loggerName, providerEpoch, mpDelegate, layer, appContext, cbh);
        this.authContextHelper = acHelper;
    }

    @Override
    protected void initializeContextMap() {
        this.contextMap = new HashMap<String, Map<Integer, ClientAuthContext>>();
    }

    protected void refreshContextHelper() {
        this.authContextHelper.refresh();
    }

    @Override
    protected <M> M createAuthContext(final String authContextID, final Map<String, ?> properties) throws AuthException {
        if (!this.authContextHelper.isProtected(new ClientAuthModule[0], authContextID)) {
            return null;
        }
        ClientAuthContext context = new ClientAuthContext(){
            ClientAuthModule[] module = this.init();

            ClientAuthModule[] init() throws AuthException {
                ClientAuthModule[] clientModules;
                try {
                    clientModules = ClientAuthConfigImpl.this.authContextHelper.getModules(new ClientAuthModule[0], authContextID);
                }
                catch (AuthException ae) {
                    ClientAuthConfigImpl.this.logIfLevel(Level.SEVERE, ae, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "unable to load client auth modules");
                    throw ae;
                }
                MessagePolicy requestPolicy = ClientAuthConfigImpl.this.policyDelegate.getRequestPolicy(authContextID, properties);
                MessagePolicy responsePolicy = ClientAuthConfigImpl.this.policyDelegate.getResponsePolicy(authContextID, properties);
                boolean noModules = true;
                for (int i = 0; i < clientModules.length; ++i) {
                    if (clientModules[i] == null) continue;
                    if (ClientAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "initializing module");
                    }
                    noModules = false;
                    ClientAuthConfigImpl.this.checkMessageTypes(clientModules[i].getSupportedMessageTypes());
                    clientModules[i].initialize(requestPolicy, responsePolicy, ClientAuthConfigImpl.this.callbackHandler, ClientAuthConfigImpl.this.authContextHelper.getInitProperties(i, properties));
                }
                if (noModules) {
                    ClientAuthConfigImpl.this.logIfLevel(Level.WARNING, null, "CLientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "contains no Auth Modules");
                }
                return clientModules;
            }

            @Override
            public AuthStatus validateResponse(MessageInfo arg0, Subject arg1, Subject arg2) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "calling vaidateResponse on module");
                    }
                    status[i] = this.module[i].validateResponse(arg0, arg1, arg2);
                    if (!ClientAuthConfigImpl.this.authContextHelper.exitContext(validateResponseSuccessValues, i, status[i])) continue;
                    return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(validateResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(validateResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            @Override
            public AuthStatus secureRequest(MessageInfo arg0, Subject arg1) throws AuthException {
                AuthStatus[] status = new AuthStatus[this.module.length];
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "calling secureResponse on module");
                    }
                    status[i] = this.module[i].secureRequest(arg0, arg1);
                    if (!ClientAuthConfigImpl.this.authContextHelper.exitContext(secureResponseSuccessValues, i, status[i])) continue;
                    return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, i);
                }
                return ClientAuthConfigImpl.this.authContextHelper.getReturnStatus(secureResponseSuccessValues, AuthStatus.SEND_FAILURE, status, status.length - 1);
            }

            @Override
            public void cleanSubject(MessageInfo arg0, Subject arg1) throws AuthException {
                for (int i = 0; i < this.module.length; ++i) {
                    if (this.module[i] == null) continue;
                    if (ClientAuthConfigImpl.this.isLoggable(Level.FINE)) {
                        ClientAuthConfigImpl.this.logIfLevel(Level.FINE, null, "ClientAuthContext: ", authContextID, "of AppContext: ", ClientAuthConfigImpl.this.getAppContext(), "calling cleanSubject on module");
                    }
                    this.module[i].cleanSubject(arg0, arg1);
                }
            }
        };
        return (M)context;
    }

    @Override
    public ClientAuthContext getAuthContext(String authContextID, Subject subject, Map properties) throws AuthException {
        return (ClientAuthContext)super.getContext(this.contextMap, authContextID, subject, properties);
    }

    @Override
    public boolean isProtected() {
        return !this.authContextHelper.returnsNullContexts() || this.policyDelegate.isProtected();
    }
}

