/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminLoginModule;
import com.sun.enterprise.admin.util.GenericAdminAuthenticator;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.common.util.admin.AdminAuthenticator;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.LocalPassword;

public class AdminCallbackHandler
implements CallbackHandler {
    public static final String COOKIE_REST_TOKEN = "gfresttoken";
    public static final String HEADER_X_AUTH_TOKEN = "X-Auth-Token";
    private static final Level PROGRESS_LEVEL = Level.FINE;
    private static final Logger LOGGER = GenericAdminAuthenticator.ADMSEC_LOGGER;
    private static final Base64.Decoder decoder = Base64.getMimeDecoder();
    private static final String BASIC = "Basic ";
    private final Request request;
    private Map<String, String> headers;
    private final Principal clientPrincipal;
    private final String originHost;
    private final PasswordAuthentication passwordAuthentication;
    private final String specialAdminIndicator;
    private final String token;
    private final String defaultAdminUsername;
    private final LocalPassword localPassword;
    private final ServiceLocator serviceLocator;

    public AdminCallbackHandler(ServiceLocator serviceLocator, Request request, String alternateHostName, String defaultAdminUsername, LocalPassword localPassword) throws IOException {
        this.serviceLocator = serviceLocator;
        this.request = request;
        this.defaultAdminUsername = defaultAdminUsername;
        this.localPassword = localPassword;
        this.clientPrincipal = request.getUserPrincipal();
        this.originHost = alternateHostName != null ? alternateHostName : request.getRemoteHost();
        this.passwordAuthentication = this.basicAuth();
        this.specialAdminIndicator = this.specialAdminIndicator();
        this.token = this.token();
    }

    ServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    private static Map<String, String> headers(Request req) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String headerName : req.getHeaderNames()) {
            result.put(AdminCallbackHandler.headerName(headerName), req.getHeader(headerName));
        }
        return result;
    }

    private static String headerName(String headerName) {
        return headerName.toLowerCase(Locale.ENGLISH);
    }

    private synchronized Map<String, String> headers() {
        if (this.headers == null) {
            this.headers = AdminCallbackHandler.headers(this.request);
        }
        return this.headers;
    }

    private String header(String headerName) {
        return this.headers().get(AdminCallbackHandler.headerName(headerName));
    }

    private PasswordAuthentication basicAuth() {
        String authHeader = this.header("Authorization");
        if (authHeader == null) {
            LOGGER.log(PROGRESS_LEVEL, "No Authorization header found; preparing default with username {0} and empty password", this.defaultAdminUsername);
            return new PasswordAuthentication(this.defaultAdminUsername, new char[0]);
        }
        String dec = new String(decoder.decode(authHeader.substring(BASIC.length())), StandardCharsets.UTF_8);
        int i = dec.indexOf(58);
        if (i < 0) {
            LOGGER.log(PROGRESS_LEVEL, "Authorization header contained no : to separate the username from the password; proceeding with an empty username and empty password");
            return new PasswordAuthentication("", new char[0]);
        }
        char[] password = dec.substring(i + 1).toCharArray();
        String username = dec.substring(0, i);
        if (username.isEmpty() && !this.localPassword.isLocalPassword(new String(password))) {
            LOGGER.log(PROGRESS_LEVEL, "Authorization header contained no username and the password is not the local password, so continue with the default username {0}", this.defaultAdminUsername);
            username = this.defaultAdminUsername;
        }
        LOGGER.log(PROGRESS_LEVEL, "basicAuth processing returning PasswordAuthentication with username {0}", username);
        return new PasswordAuthentication(username, password);
    }

    private String specialAdminIndicator() {
        return this.header("X-GlassFish-admin");
    }

    private String token() {
        return this.header("X-GlassFish-authToken");
    }

    private String restToken() {
        Cookie[] cookies = this.request.getCookies();
        String result = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_REST_TOKEN.equals(cookie.getName())) continue;
                result = cookie.getValue();
            }
        }
        if (result == null) {
            result = this.request.getHeader(HEADER_X_AUTH_TOKEN);
        }
        return result;
    }

    public String getRemoteHost() {
        return this.originHost;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback cb : callbacks) {
            if (cb instanceof NameCallback) {
                ((NameCallback)cb).setName(this.passwordAuthentication.getUserName());
                continue;
            }
            if (cb instanceof PasswordCallback) {
                ((PasswordCallback)cb).setPassword(this.passwordAuthentication.getPassword());
                continue;
            }
            if (cb instanceof TextInputCallback) {
                TextInputCallback ticb = (TextInputCallback)cb;
                String prompt = ticb.getPrompt();
                if (AdminAuthenticator.AuthenticatorType.ADMIN_INDICATOR.name().equals(prompt)) {
                    ticb.setText(this.specialAdminIndicator());
                    continue;
                }
                if (AdminAuthenticator.AuthenticatorType.ADMIN_TOKEN.name().equals(prompt)) {
                    ticb.setText(this.token());
                    continue;
                }
                if (AdminAuthenticator.AuthenticatorType.REMOTE_HOST.name().equals(prompt)) {
                    ticb.setText(this.remoteHost());
                    continue;
                }
                if (AdminAuthenticator.AuthenticatorType.REST_TOKEN.name().equals(prompt)) {
                    ticb.setText(this.restToken());
                    continue;
                }
                if (!AdminAuthenticator.AuthenticatorType.REMOTE_ADDR.name().equals(prompt)) continue;
                ticb.setText(this.remoteAddr());
                continue;
            }
            if (!(cb instanceof AdminLoginModule.PrincipalCallback)) continue;
            ((AdminLoginModule.PrincipalCallback)cb).setPrincipal(this.clientPrincipal);
        }
    }

    PasswordAuthentication pw() {
        return this.passwordAuthentication;
    }

    Principal clientPrincipal() {
        return this.clientPrincipal;
    }

    String tkn() {
        return this.token;
    }

    String remoteHost() {
        return this.originHost;
    }

    String adminIndicator() {
        return this.specialAdminIndicator;
    }

    String remoteAddr() {
        return this.request.getRemoteAddr();
    }
}

