/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import org.apache.catalina.CometEvent;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.glassfish.web.valve.GlassFishValve;

public abstract class ValveBase
implements Contained,
Lifecycle,
Valve,
GlassFishValve {
    protected static final Logger log = LogFacade.getLogger();
    protected static final ResourceBundle rb = log.getResourceBundle();
    protected Container container = null;
    protected int debug = 0;
    protected boolean started = false;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String info = "org.apache.catalina.core.ValveBase/1.0";
    protected Valve next = null;
    protected String domain;
    protected ObjectName oname;
    protected ObjectName controller;

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Valve getNext() {
        return this.next;
    }

    @Override
    public void setNext(Valve valve) {
        this.next = valve;
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public abstract int invoke(Request var1, Response var2) throws IOException, ServletException;

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
    }

    @Override
    public void invoke(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
    }

    @Override
    public void event(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response, CometEvent event) throws IOException, ServletException {
        if (this.getNext() != null) {
            this.getNext().event(request, response, event);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            return;
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public void setObjectName(ObjectName oname) {
        this.oname = oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    public ObjectName getParentName(ObjectName valveName) {
        return null;
    }

    public ObjectName createObjectName(String domain, ObjectName parent) throws MalformedObjectNameException {
        String className;
        int period;
        Container container = this.getContainer();
        if (container == null || !(container instanceof ContainerBase)) {
            return null;
        }
        ContainerBase containerBase = (ContainerBase)container;
        Pipeline pipe = containerBase.getPipeline();
        GlassFishValve[] valves = pipe.getValves();
        String parentName = "";
        if (!(container instanceof Engine)) {
            if (container instanceof Host) {
                parentName = ",host=" + container.getName();
            } else if (container instanceof Context) {
                String path = ((Context)container).getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)container.getParent();
                parentName = ",path=" + path + ",host=" + host.getName();
            } else if (container instanceof Wrapper) {
                Context ctx = (Context)container.getParent();
                String path = ctx.getPath();
                if (path.length() < 1) {
                    path = "/";
                }
                Host host = (Host)ctx.getParent();
                parentName = ",servlet=" + container.getName() + ",path=" + path + ",host=" + host.getName();
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "valve parent={0} {1}", new Object[]{parentName, parent});
        }
        if ((period = (className = this.getClass().getName()).lastIndexOf(46)) >= 0) {
            className = className.substring(period + 1);
        }
        int seq = 0;
        for (GlassFishValve valve : valves) {
            if (valve == this) break;
            if (valve == null || valve.getClass() != this.getClass()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Duplicate {0} {1} {2}", new Object[]{valve, this, container});
            }
            ++seq;
        }
        String ext = "";
        if (seq > 0) {
            ext = ",seq=" + seq;
        }
        ObjectName objectName = new ObjectName(domain + ":type=Valve,name=" + className + ext + parentName);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "valve objectname = {0}", objectName);
        }
        return objectName;
    }
}

