/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.cdi.extension.cluster;

import com.sun.enterprise.deployment.Application;
import fish.payara.cluster.Clustered;
import fish.payara.micro.cdi.extension.cluster.ClusterScopeContext;
import fish.payara.micro.cdi.extension.cluster.ClusterScopedInterceptor;
import fish.payara.micro.cdi.extension.cluster.ClusteredAnnotatedType;
import fish.payara.micro.cdi.extension.cluster.annotations.ClusterScoped;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.deployment.Deployment;

public class ClusteredAnnotationProcessor {
    private Deployment deployment;

    public void beforeBeanDiscovery(BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addScope(ClusterScoped.class, true, true);
        this.deployment = (Deployment)Globals.getDefaultHabitat().getService(Deployment.class, new Annotation[0]);
        event.addAnnotatedType(beanManager.createAnnotatedType(ClusterScopedInterceptor.class), ClusterScopedInterceptor.class.getName());
    }

    public void afterBeanDiscovery(AfterBeanDiscovery event, BeanManager manager) {
        event.addContext((Context)new ClusterScopeContext(manager, this.deployment));
    }

    public <X> void processAnnotatedType(ProcessAnnotatedType<X> annotatedType, BeanManager beanManager) {
        Clustered clusteredAnnotation = (Clustered)annotatedType.getAnnotatedType().getAnnotation(Clustered.class);
        if (clusteredAnnotation != null && !this.isEJB(annotatedType)) {
            this.validate(annotatedType.getAnnotatedType(), beanManager);
            annotatedType.setAnnotatedType(new ClusteredAnnotatedType(annotatedType.getAnnotatedType()));
        }
    }

    private <X> boolean isEJB(ProcessAnnotatedType<X> annotatedType) {
        String className = annotatedType.getAnnotatedType().getJavaClass().getName();
        Application application = (Application)this.deployment.getCurrentDeploymentContext().getModuleMetaData(Application.class);
        for (EjbBundleDescriptorImpl bundleDescriptor : application.getBundleDescriptors(EjbBundleDescriptorImpl.class)) {
            if (bundleDescriptor.getEjbByClassName(className).length <= 0) continue;
            return true;
        }
        return false;
    }

    private <X> void validate(AnnotatedType<X> annotatedType, BeanManager beanManager) {
        if (!annotatedType.isAnnotationPresent(ApplicationScoped.class)) {
            throw new IllegalArgumentException("Only @ApplicationScoped beans can be @Clustered: " + annotatedType.toString());
        }
        if (!Serializable.class.isAssignableFrom(annotatedType.getJavaClass())) {
            throw new IllegalStateException(String.format("Clustered @ApplicationScoped %s must be Serializable", annotatedType.toString()));
        }
    }
}

