/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.auth.realm.AbstractRealm;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.GroupMapper;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManagerStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Stream;

public abstract class AbstractStatefulRealm
extends AbstractRealm
implements Comparable<Realm> {
    private static final Logger LOG = Logger.getLogger(AbstractStatefulRealm.class.getName());
    public static final String PARAM_GROUP_MAPPING = "group-mapping";
    public static final String PARAM_GROUPS = "assign-groups";
    public static final String PARAM_DEFAULT_DIGEST_ALGORITHM = "default-digest-algorithm";
    protected static final String GROUPS_SEP = ",";
    private static final String DEFAULT_DIG_ALGORITHM = "SHA-256";
    private String realmName;
    private List<String> assignGroups = Collections.emptyList();
    private final Properties contextProperties = new Properties();
    protected GroupMapper groupMapper;

    protected AbstractStatefulRealm() {
    }

    protected void init(Properties properties) throws BadRealmException, NoSuchRealmException {
        String groupMapping;
        LOG.config(() -> String.format("init(properties: %s)", properties));
        String groupList = properties.getProperty(PARAM_GROUPS);
        if (groupList != null && !groupList.isEmpty()) {
            this.setProperty(PARAM_GROUPS, groupList);
            this.assignGroups = new ArrayList<String>();
            for (String group : groupList.split(GROUPS_SEP)) {
                if (this.assignGroups.contains(group)) continue;
                this.assignGroups.add(group);
            }
        }
        if ((groupMapping = properties.getProperty(PARAM_GROUP_MAPPING)) != null) {
            this.groupMapper = new GroupMapper();
            this.groupMapper.parse(groupMapping);
        }
        String defaultDigestAlg = RealmsManagerStore._getRealmsManager() == null ? DEFAULT_DIG_ALGORITHM : RealmsManagerStore._getRealmsManager().getDefaultDigestAlgorithm();
        this.setProperty(DEFAULT_DIG_ALGORITHM, defaultDigestAlg);
    }

    protected String[] addAssignGroups(String[] groups) {
        if (groups == null || groups.length == 0) {
            return this.assignGroups.toArray(new String[this.assignGroups.size()]);
        }
        if (this.assignGroups.isEmpty()) {
            return groups;
        }
        return (String[])Stream.concat(Arrays.stream(groups), this.assignGroups.stream()).distinct().toArray(String[]::new);
    }

    protected ArrayList<String> getMappedGroupNames(String group) {
        if (this.groupMapper == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        this.groupMapper.getMappedGroups(group, result);
        return result;
    }

    public void refresh(String configName) throws BadRealmException {
    }

    public final String getName() {
        return this.realmName;
    }

    protected final void setName(String name) {
        if (this.realmName != null) {
            return;
        }
        this.realmName = name;
    }

    protected String getDefaultDigestAlgorithm() {
        String defaultDigestAlgorithm = this.contextProperties.getProperty(PARAM_DEFAULT_DIGEST_ALGORITHM);
        return defaultDigestAlgorithm == null || defaultDigestAlgorithm.trim().isEmpty() ? DEFAULT_DIG_ALGORITHM : defaultDigestAlgorithm;
    }

    public synchronized String getProperty(String name) {
        return this.contextProperties.getProperty(name);
    }

    public synchronized void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        this.contextProperties.setProperty(name, value);
    }

    protected synchronized Properties getProperties() {
        return this.contextProperties;
    }

    public synchronized String getJAASContext() {
        return this.contextProperties.getProperty("jaas-context");
    }

    public String toString() {
        return this.realmName;
    }

    @Override
    public int compareTo(Realm otherRealm) {
        String str = otherRealm.getAuthType();
        int temp = this.getAuthType().compareTo(str);
        if (temp != 0) {
            return temp;
        }
        return this.getName().compareTo(otherRealm.getName());
    }
}

