/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="garbage-collector-mon", group="monitoring")
@ManagedObject
@Description(value="JVM Garbage Collectors Statistics")
public class JVMGCStatsProvider {
    private final List<GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
    private String gcName = null;
    private final CountStatisticImpl collectionCount = new CountStatisticImpl("CollectionCount", "count", "Total number of collections that have occurred");
    private final CountStatisticImpl collectionTimeCount = new CountStatisticImpl("CollectionTime", "millisecond", "Approximate accumulated collection elapsed time in milliseconds");

    public JVMGCStatsProvider(String gcName) {
        this.gcName = gcName;
    }

    public String getGcName() {
        return this.gcName;
    }

    @ManagedAttribute(id="collectioncount-count")
    @Description(value="total number of collections that have occurred")
    public CountStatistic getCollectionCount() {
        long counts = -1L;
        for (GarbageCollectorMXBean gcBean : this.gcBeanList) {
            if (!gcBean.getName().equals(this.gcName)) continue;
            counts = gcBean.getCollectionCount();
        }
        this.collectionCount.setCount(counts);
        return this.collectionCount;
    }

    @ManagedAttribute(id="collectiontime-count")
    @Description(value="approximate accumulated collection elapsed time in milliseconds")
    public CountStatistic getCollectionTime() {
        long times = -1L;
        for (GarbageCollectorMXBean gcBean : this.gcBeanList) {
            if (!gcBean.getName().equals(this.gcName)) continue;
            times = gcBean.getCollectionTime();
        }
        this.collectionTimeCount.setCount(times);
        return this.collectionTimeCount;
    }
}

