/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ParamConverterProvider;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam;
import org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptorFactory;
import org.eclipse.microprofile.rest.client.ext.ClientHeadersFactory;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.glassfish.jersey.client.inject.ParameterUpdater;
import org.glassfish.jersey.client.inject.ParameterUpdaterProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.microprofile.restclient.ClientHeaderParamModel;
import org.glassfish.jersey.microprofile.restclient.ReflectionUtil;
import org.glassfish.jersey.model.Parameter;

class InterfaceModel {
    private final InjectionManager injectionManager;
    private final Class<?> restClientClass;
    private final String[] produces;
    private final String[] consumes;
    private final String path;
    private final ClientHeadersFactory clientHeadersFactory;
    private final CreationalContext<?> creationalContext;
    private final List<ClientHeaderParamModel> clientHeaders;
    private final List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories;
    private final Set<ResponseExceptionMapper> responseExceptionMappers;
    private final Set<ParamConverterProvider> paramConverterProviders;
    private final Set<Annotation> interceptorAnnotations;
    private final BeanManager beanManager;

    static InterfaceModel from(Class<?> restClientClass, Set<ResponseExceptionMapper> responseExceptionMappers, Set<ParamConverterProvider> paramConverterProviders, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories, InjectionManager injectionManager, BeanManager beanManager) {
        return new Builder(restClientClass, responseExceptionMappers, paramConverterProviders, asyncInterceptorFactories, injectionManager, beanManager).build();
    }

    private InterfaceModel(Builder builder) {
        this.injectionManager = builder.injectionManager;
        this.restClientClass = builder.restClientClass;
        this.path = builder.pathValue;
        this.produces = builder.produces;
        this.consumes = builder.consumes;
        this.clientHeaders = builder.clientHeaders;
        this.clientHeadersFactory = builder.clientHeadersFactory;
        this.responseExceptionMappers = builder.responseExceptionMappers;
        this.paramConverterProviders = builder.paramConverterProviders;
        this.interceptorAnnotations = builder.interceptorAnnotations;
        this.creationalContext = builder.creationalContext;
        this.asyncInterceptorFactories = builder.asyncInterceptorFactories;
        this.beanManager = builder.beanManager;
    }

    Class<?> getRestClientClass() {
        return this.restClientClass;
    }

    String[] getProduces() {
        return this.produces;
    }

    String[] getConsumes() {
        return this.consumes;
    }

    String getPath() {
        return this.path;
    }

    Optional<ClientHeadersFactory> getClientHeadersFactory() {
        return Optional.ofNullable(this.clientHeadersFactory);
    }

    List<ClientHeaderParamModel> getClientHeaders() {
        return this.clientHeaders;
    }

    List<AsyncInvocationInterceptorFactory> getAsyncInterceptorFactories() {
        return this.asyncInterceptorFactories;
    }

    Set<ResponseExceptionMapper> getResponseExceptionMappers() {
        return this.responseExceptionMappers;
    }

    Set<ParamConverterProvider> getParamConverterProviders() {
        return this.paramConverterProviders;
    }

    Set<Annotation> getInterceptorAnnotations() {
        return this.interceptorAnnotations;
    }

    CreationalContext<?> getCreationalContext() {
        return this.creationalContext;
    }

    public InjectionManager getInjectionManager() {
        return this.injectionManager;
    }

    Object resolveParamValue(Object arg, Parameter parameter) {
        Iterable parameterUpdaterProviders = Providers.getAllProviders((InjectionManager)this.injectionManager, ParameterUpdaterProvider.class);
        for (ParameterUpdaterProvider parameterUpdaterProvider : parameterUpdaterProviders) {
            if (parameterUpdaterProvider == null) continue;
            ParameterUpdater updater = parameterUpdaterProvider.get(parameter);
            return updater.update(arg);
        }
        return arg;
    }

    BeanManager getBeanManager() {
        return this.beanManager;
    }

    private static class Builder {
        private final Class<?> restClientClass;
        private final InjectionManager injectionManager;
        private final BeanManager beanManager;
        private String pathValue;
        private String[] produces;
        private String[] consumes;
        private ClientHeadersFactory clientHeadersFactory;
        private CreationalContext<?> creationalContext;
        private List<ClientHeaderParamModel> clientHeaders;
        private List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories;
        private Set<ResponseExceptionMapper> responseExceptionMappers;
        private Set<ParamConverterProvider> paramConverterProviders;
        private Set<Annotation> interceptorAnnotations;

        private Builder(Class<?> restClientClass, Set<ResponseExceptionMapper> responseExceptionMappers, Set<ParamConverterProvider> paramConverterProviders, List<AsyncInvocationInterceptorFactory> asyncInterceptorFactories, InjectionManager injectionManager, BeanManager beanManager) {
            this.injectionManager = injectionManager;
            this.restClientClass = restClientClass;
            this.responseExceptionMappers = responseExceptionMappers;
            this.paramConverterProviders = paramConverterProviders;
            this.asyncInterceptorFactories = asyncInterceptorFactories;
            this.beanManager = beanManager;
            this.filterAllInterceptorAnnotations();
        }

        private void filterAllInterceptorAnnotations() {
            this.creationalContext = null;
            this.interceptorAnnotations = new HashSet<Annotation>();
            if (this.beanManager != null) {
                this.creationalContext = this.beanManager.createCreationalContext(null);
                for (Annotation annotation : this.restClientClass.getAnnotations()) {
                    if (!this.beanManager.isInterceptorBinding(annotation.annotationType())) continue;
                    this.interceptorAnnotations.add(annotation);
                }
            }
        }

        Builder pathValue(Path path) {
            this.pathValue = path != null ? path.value() : "";
            this.pathValue = this.pathValue.equals("/") ? "" : this.pathValue;
            return this;
        }

        Builder produces(Produces produces) {
            String[] stringArray;
            if (produces != null) {
                stringArray = produces.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "application/json";
            }
            this.produces = stringArray;
            return this;
        }

        Builder consumes(Consumes consumes) {
            String[] stringArray;
            if (consumes != null) {
                stringArray = consumes.value();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "application/json";
            }
            this.consumes = stringArray;
            return this;
        }

        Builder clientHeaders(ClientHeaderParam[] clientHeaderParams) {
            this.clientHeaders = Arrays.stream(clientHeaderParams).map(clientHeaderParam -> new ClientHeaderParamModel(this.restClientClass, (ClientHeaderParam)clientHeaderParam)).collect(Collectors.toList());
            return this;
        }

        Builder clientHeadersFactory(RegisterClientHeaders registerClientHeaders) {
            this.clientHeadersFactory = registerClientHeaders != null ? this.initialiseClientHeadersFactory(registerClientHeaders) : null;
            return this;
        }

        private ClientHeadersFactory initialiseClientHeadersFactory(RegisterClientHeaders annotation) {
            Bean bean;
            if (this.beanManager != null && (bean = this.beanManager.resolve(this.beanManager.getBeans((Type)annotation.value(), new Annotation[0]))) != null) {
                CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
                return (ClientHeadersFactory)this.beanManager.getReference(bean, (Type)bean.getBeanClass(), ctx);
            }
            return (ClientHeadersFactory)ReflectionUtil.createInstance(annotation.value());
        }

        InterfaceModel build() {
            this.pathValue(this.restClientClass.getAnnotation(Path.class));
            this.produces(this.restClientClass.getAnnotation(Produces.class));
            this.consumes(this.restClientClass.getAnnotation(Consumes.class));
            this.clientHeaders((ClientHeaderParam[])this.restClientClass.getAnnotationsByType(ClientHeaderParam.class));
            this.clientHeadersFactory(this.restClientClass.getAnnotation(RegisterClientHeaders.class));
            this.validateHeaderDuplicityNames();
            return new InterfaceModel(this);
        }

        private void validateHeaderDuplicityNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (ClientHeaderParamModel clientHeaderParamModel : this.clientHeaders) {
                String headerName = clientHeaderParamModel.getHeaderName();
                if (names.contains(headerName)) {
                    throw new RestClientDefinitionException("Header name cannot be registered more then once on the same target.See " + this.restClientClass.getName());
                }
                names.add(headerName);
            }
        }
    }
}

