/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.appserv.util.cache.LruCache;
import com.sun.ejb.base.stats.StatefulSessionStoreMonitor;
import com.sun.ejb.containers.util.cache.LruEJBCache;
import com.sun.ejb.monitoring.stats.EjbCacheStatsProviderDelegate;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import com.sun.ejb.spi.container.StatefulEJBContext;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import javax.ejb.EJBException;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.util.SimpleMetadata;
import org.glassfish.logging.annotation.LogMessageInfo;

public class LruSessionCache
extends LruEJBCache
implements EjbCacheStatsProviderDelegate {
    @LogMessageInfo(message="[{0}]: Exception in backingStore.remove([{1}])", level="WARNING")
    private static final String EXCEPTION_BACKING_STORE_REMOVE = "AS-EJB-00002";
    @LogMessageInfo(message="[{0}]: passivateEJB(), Exception caught ->", level="WARNING")
    private static final String PASSIVATE_EJB_EXCEPTION_CAUGHT = "AS-EJB-00003";
    @LogMessageInfo(message="[{0}]: Cannot load from  BACKUPSTORE FOR Key: <[{1}]>", level="SEVERE", cause="Didn't find the data related with the given session key.", action="Check if the session bean already timed out.")
    private static final String CANNOT_LOAD_FROM_BACKUP_STORE = "AS-EJB-00004";
    @LogMessageInfo(message="[{0}]: Exception while  loading from backup session: <[{1}]>", level="SEVERE", cause="Session store exception or deserialization exception happened.", action="Check error message and exception stack.")
    private static final String EXCEPTION_LOADING_BACKUP_SESSION = "AS-EJB-00005";
    @LogMessageInfo(message="[{0}]: Error while  loading from backup session: <[{1}]>", level="SEVERE", cause="Session store error or deserialization error happened.", action="Check error message and exception stack.")
    private static final String ERROR_LOADING_BACKUP_SESSION = "AS-EJB-00006";
    @LogMessageInfo(message="[{0}]: Exception during backingStore.passivateSave([{1}])", level="WARNING")
    private static final String EXCEPTION_DURING_PASSIVATE_SAVE = "AS-EJB-00007";
    @LogMessageInfo(message="[{0}]: Iterator(), resetting head.lPrev", level="WARNING")
    private static final String ITERATOR_RESETTING_HEAD_LPREV = "AS-EJB-00008";
    @LogMessageInfo(message="[{0}]: Exiting TrimTimedoutBeans() because current cache state: [{1}]", level="WARNING")
    private static final String EXITING_TRIM_TIMEDOUT_BEANS = "AS-EJB-00009";
    @LogMessageInfo(message="[{0}]: TrimTimedoutBeans(), resetting head.lPrev", level="WARNING")
    private static final String TRIM_TIMEDOUT_BEANS_RESETTING_HEAD_LPREV = "AS-EJB-00010";
    @LogMessageInfo(message="[{0}]: Exiting TrimUnSortedTimedoutBeans() because current cache state: [{1}]", level="WARNING")
    private static final String EXITING_TRIM_UNSORTED_TIMEDOUT_BEANS = "AS-EJB-00011";
    @LogMessageInfo(message="Cannot find stateful session bean [{0}] in memory, and will not read it from disk because current stateful session bean passivation-capable value is false", level="INFO")
    private static final String SFSB_NOT_FOUND_WHEN_PASSIVATION_DISABLED = "AS-EJB-00049";
    protected int cacheIdleTimeoutInSeconds;
    protected int removalTimeoutInSeconds;
    protected Object loadCountLock = new Object();
    protected int loadFromBackupCount;
    protected boolean removeIfIdle = false;
    private int numVictimsAccessed = 0;
    protected SFSBContainerCallback container;
    protected BackingStore<Serializable, SimpleMetadata> backingStore;
    private static final byte CACHE_ITEM_VALID = 0;
    private static final byte CACHE_ITEM_LOADING = 1;
    private static final byte CACHE_ITEM_REMOVED = 2;
    protected String configData;
    private static final int STATE_RUNNING = 0;
    private static final int STATE_SHUTTING_DOWN = 1;
    private static final int STATE_UNDEPLOYING = 2;
    private static final int STATE_DESTROYED = 3;
    private int currentCacheState = 0;
    protected int confMaxCacheSize = Integer.MAX_VALUE;

    public void destroy() {
        this.currentCacheState = 3;
        this.container = null;
        super.destroy();
    }

    public LruSessionCache(String cacheName, SFSBContainerCallback container, int cacheIdleTime, int removalTime) {
        super.setCacheName(cacheName);
        this.container = container;
        this.cacheIdleTimeoutInSeconds = cacheIdleTime <= 0 ? 0 : cacheIdleTime;
        int n = this.removalTimeoutInSeconds = removalTime <= 0 ? 0 : removalTime;
        if (this.cacheIdleTimeoutInSeconds > 0) {
            this.timeout = (long)this.cacheIdleTimeoutInSeconds * 1000L;
        }
        this.removeIfIdle = this.removalTimeoutInSeconds > 0 && this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds;
    }

    public void setBackingStore(BackingStore<Serializable, SimpleMetadata> store) {
        this.backingStore = store;
    }

    public void setStatefulSessionStoreMonitor(StatefulSessionStoreMonitor storeMonitor) {
    }

    protected void trimItem(BaseCache.CacheItem item) {
        LruCache.LruCacheItem removed = (LruCache.LruCacheItem)item;
        if (this.removeIfIdle) {
            StatefulEJBContext ctx = (StatefulEJBContext)item.getValue();
            long idleThreshold = System.currentTimeMillis() - (long)this.removalTimeoutInSeconds * 1000L;
            if (ctx.getLastAccessTime() <= idleThreshold) {
                this.container.passivateEJB(ctx);
                return;
            }
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheListener listener = (CacheListener)this.listeners.get(i);
            listener.trimEvent(removed.getKey(), removed.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem item) {
        LruCache.LruCacheItem lc = (LruCache.LruCacheItem)item;
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (lc.isTrimmed()) {
                lc.setTrimmed(false);
                ++this.numVictimsAccessed;
                BaseCache.CacheItem overflow = super.itemAdded(item);
                if (overflow != null) {
                    this.trimItem(overflow);
                }
            } else {
                super.itemAccessed(item);
            }
        }
    }

    public int getLoadFromBackupCount() {
        return this.loadFromBackupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLoadFromBackupCount() {
        Object object = this.loadCountLock;
        synchronized (object) {
            ++this.loadFromBackupCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulEJBContext lookupEJB(Serializable sessionKey, SFSBContainerCallback container, Object cookie) {
        int hashCode = this.hash(sessionKey);
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem item = null;
        LruSessionCacheItem newItem = null;
        Object value = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            for (item = this.buckets[index]; item != null; item = item.getNext()) {
                if (hashCode != item.getHashCode() || !item.getKey().equals(sessionKey)) continue;
                value = item.getValue();
                break;
            }
            if (value != null) {
                this.itemAccessed(item);
            }
        }
        if (value != null) {
            this.incrementHitCount();
            return (StatefulEJBContext)value;
        }
        this.incrementMissCount();
        if (item != null) {
            object = item;
            synchronized (object) {
                LruSessionCacheItem lruItem = (LruSessionCacheItem)item;
                if (lruItem.getValue() == null && lruItem.cacheItemState == 1) {
                    lruItem.waitCount = (byte)(lruItem.waitCount + 1);
                    try {
                        item.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return (StatefulEJBContext)item.getValue();
            }
        }
        if (!container.isPassivationCapable()) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, SFSB_NOT_FOUND_WHEN_PASSIVATION_DISABLED);
            }
            return null;
        }
        long activationStartTime = -1L;
        try {
            value = this.getStateFromStore(sessionKey, container);
            newItem = new LruSessionCacheItem(hashCode, sessionKey, value, -1, 1);
            newItem.setNext(this.buckets[index]);
            this.buckets[index] = newItem;
            Object object2 = this.buckets[index];
            synchronized (object2) {
                if (value == null) {
                    BaseCache.CacheItem prev = null;
                    for (BaseCache.CacheItem current = this.buckets[index]; current != null; current = current.getNext()) {
                        if (current == newItem) {
                            if (prev == null) {
                                this.buckets[index] = current.getNext();
                            } else {
                                prev.setNext(current.getNext());
                            }
                            current.setNext(null);
                            break;
                        }
                        prev = current;
                    }
                } else {
                    container.activateEJB(sessionKey, (StatefulEJBContext)value, cookie);
                    BaseCache.CacheItem overflow = this.itemAdded((BaseCache.CacheItem)newItem);
                    this.incrementEntryCount();
                    if (overflow != null) {
                        this.trimItem(overflow);
                    }
                }
            }
        }
        catch (EJBException ejbEx) {
            this.remove(sessionKey);
            value = null;
        }
        finally {
            if (newItem != null) {
                LruSessionCacheItem lruSessionCacheItem = newItem;
                synchronized (lruSessionCacheItem) {
                    newItem.cacheItemState = 0;
                    if (newItem.waitCount > 0) {
                        ((Object)((Object)newItem)).notifyAll();
                    }
                }
            }
            if (activationStartTime != -1L) {
                long l = System.currentTimeMillis() - activationStartTime;
            }
        }
        return (StatefulEJBContext)value;
    }

    public Object remove(Object sessionKey) {
        return this.remove(sessionKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object sessionKey, boolean removeFromStore) {
        int hashCode = this.hash(sessionKey);
        int index = this.getIndex(hashCode);
        BaseCache.CacheItem prev = null;
        BaseCache.CacheItem item = null;
        Object object = this.bucketLocks[index];
        synchronized (object) {
            for (item = this.buckets[index]; item != null; item = item.getNext()) {
                if (hashCode == item.getHashCode() && sessionKey.equals(item.getKey())) {
                    if (prev == null) {
                        this.buckets[index] = item.getNext();
                    } else {
                        prev.setNext(item.getNext());
                    }
                    item.setNext(null);
                    this.itemRemoved(item);
                    ((LruSessionCacheItem)item).cacheItemState = (byte)2;
                    break;
                }
                prev = item;
            }
            if (removeFromStore) {
                try {
                    if (this.backingStore != null) {
                        this.backingStore.remove((Serializable)sessionKey);
                    }
                }
                catch (BackingStoreException sfsbEx) {
                    _logger.log(Level.WARNING, EXCEPTION_BACKING_STORE_REMOVE, new Object[]{this.cacheName, sessionKey, sfsbEx});
                }
            }
        }
        if (item != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return null;
    }

    public boolean eligibleForRemovalFromCache(StatefulEJBContext ctx, Serializable sessionKey) {
        if (this.removeIfIdle) {
            long idleThreshold = System.currentTimeMillis() - (long)this.removalTimeoutInSeconds * 1000L;
            if (ctx.getLastAccessTime() <= idleThreshold) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.cacheName + ": Removing session  instead of passivating for key: " + sessionKey);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passivateEJB(StatefulEJBContext ctx, Serializable sessionKey) throws NotSerializableException {
        try {
            LruCache.LruCacheItem lruSCItem;
            int hashCode = this.hash(sessionKey);
            int index = this.getIndex(hashCode);
            BaseCache.CacheItem prev = null;
            BaseCache.CacheItem item = null;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                for (item = this.buckets[index]; item != null; item = item.getNext()) {
                    if (item.getValue() == ctx) {
                        lruSCItem = (LruCache.LruCacheItem)item;
                        if (lruSCItem.isTrimmed()) break;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": session accessed after marked for passivation: " + sessionKey);
                        }
                        return false;
                    }
                    prev = item;
                }
                if (item == null) {
                    return true;
                }
            }
            if (this.container.isPassivationCapable() && !this.saveStateToStore(sessionKey, ctx)) {
                return false;
            }
            object = this.bucketLocks[index];
            synchronized (object) {
                prev = null;
                for (item = this.buckets[index]; item != null; item = item.getNext()) {
                    if (item.getValue() == ctx) {
                        lruSCItem = (LruCache.LruCacheItem)item;
                        if (!lruSCItem.isTrimmed()) {
                            return false;
                        }
                        if (prev == null) {
                            this.buckets[index] = item.getNext();
                        } else {
                            prev.setNext(item.getNext());
                        }
                        item.setNext(null);
                        break;
                    }
                    prev = item;
                }
            }
            if (item != null) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
            }
            return true;
        }
        catch (NotSerializableException notSerEx) {
            _logger.log(Level.FINE, "", notSerEx);
            throw notSerEx;
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, PASSIVATE_EJB_EXCEPTION_CAUGHT, new Object[]{this.cacheName, ex});
            _logger.log(Level.FINE, "", ex);
            return false;
        }
    }

    private Object getStateFromStore(Serializable sessionKey, SFSBContainerCallback container) {
        Object object = null;
        try {
            byte[] data;
            SimpleMetadata beanState = null;
            if (this.backingStore != null) {
                beanState = (SimpleMetadata)this.backingStore.load(sessionKey, null);
            }
            byte[] byArray = data = beanState != null ? beanState.getState() : null;
            if (data == null) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, CANNOT_LOAD_FROM_BACKUP_STORE, new Object[]{this.cacheName, sessionKey});
                }
            } else {
                this.incrementLoadFromBackupCount();
                object = container.deserializeData(data);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, EXCEPTION_LOADING_BACKUP_SESSION, new Object[]{this.cacheName, sessionKey, ex});
        }
        catch (Error ex) {
            _logger.log(Level.SEVERE, ERROR_LOADING_BACKUP_SESSION, new Object[]{this.cacheName, sessionKey, ex});
        }
        return object;
    }

    private boolean saveStateToStore(Serializable sessionKey, StatefulEJBContext ctx) throws NotSerializableException, IOException {
        byte[] data = this.container.serializeContext(ctx);
        boolean status = false;
        if (data != null) {
            SimpleMetadata beanState = new SimpleMetadata(ctx.getVersion(), ctx.getLastAccessTime(), (long)this.removalTimeoutInSeconds * 1000L, data);
            beanState.setVersion(ctx.getVersion());
            try {
                if (this.backingStore != null) {
                    this.backingStore.save(sessionKey, (Serializable)beanState, !ctx.existsInStore());
                    status = true;
                }
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, EXCEPTION_DURING_PASSIVATE_SAVE, new Object[]{this.cacheName, sessionKey, sfsbEx});
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedVictims(ArrayList victims) {
        int sz = victims.size();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            this.trimCount += sz;
        }
        BaseCache.CacheItem item = null;
        for (int i = 0; i < sz; ++i) {
            item = (BaseCache.CacheItem)victims.get(i);
            this.trimItem(item);
        }
    }

    public void setShutdownState() {
        this.currentCacheState = 1;
    }

    public void setUndeployedState() {
        this.currentCacheState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator values() {
        ArrayList<StatefulEJBContext> valueList = new ArrayList<StatefulEJBContext>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            for (LruCache.LruCacheItem item = this.tail; item != null; item = item.getLPrev()) {
                StatefulEJBContext ctx = (StatefulEJBContext)item.getValue();
                if (ctx != null) {
                    valueList.add(ctx);
                }
                if (item != this.head || item.getLPrev() == null) continue;
                _logger.log(Level.WARNING, ITERATOR_RESETTING_HEAD_LPREV, this.cacheName);
                item.setLPrev(null);
            }
        }
        return valueList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ArrayList<StatefulEJBContext> valueList = new ArrayList<StatefulEJBContext>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            for (LruCache.LruCacheItem item = this.tail; item != null; item = item.getLPrev()) {
                StatefulEJBContext ctx = (StatefulEJBContext)item.getValue();
                if (ctx != null) {
                    item.setTrimmed(true);
                    valueList.add(ctx);
                }
                if (item != this.head || item.getLPrev() == null) continue;
                _logger.log(Level.WARNING, ITERATOR_RESETTING_HEAD_LPREV, this.cacheName);
                item.setLPrev(null);
            }
        }
        for (StatefulEJBContext ctx : valueList) {
            this.container.passivateEJB(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimTimedoutItems(int maxTrimCount) {
        int count = 0;
        long currentTime = System.currentTimeMillis();
        long idleThresholdTime = currentTime - (long)this.cacheIdleTimeoutInSeconds * 1000L;
        ArrayList<LruCache.LruCacheItem> victimList = new ArrayList<LruCache.LruCacheItem>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans started...");
            }
            if (this.tail == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans  finished after removing 0 idle beans");
                }
                this.head = null;
                return;
            }
            LruCache.LruCacheItem item = this.tail;
            while (true) {
                if (this.currentCacheState != 0) {
                    _logger.log(Level.WARNING, EXITING_TRIM_TIMEDOUT_BEANS, new Object[]{this.cacheName, this.currentCacheState});
                    break;
                }
                StatefulEJBContext ctx = (StatefulEJBContext)item.getValue();
                if (ctx != null) {
                    if (ctx.getLastAccessTime() > idleThresholdTime || !ctx.canBePassivated()) break;
                    item.setTrimmed(true);
                    victimList.add(item);
                }
                if (item == this.head && item.getLPrev() != null) {
                    _logger.log(Level.WARNING, TRIM_TIMEDOUT_BEANS_RESETTING_HEAD_LPREV, this.cacheName);
                    item.setLPrev(null);
                }
                if ((item = item.getLPrev()) == null) break;
                item.getLNext().setLPrev(null);
                item.getLNext().setLNext(null);
                item.setLNext(null);
            }
            if (item == this.tail) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans  finished after removing 0 idle beans");
                }
                return;
            }
            if (item == null) {
                this.head = null;
            }
            this.tail = item;
            count = victimList.size();
            this.listSize -= count;
            this.trimCount += count;
        }
        for (int idx = 0; idx < count; ++idx) {
            this.trimItem((BaseCache.CacheItem)((LruCache.LruCacheItem)victimList.get(idx)));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimTimedoutBeans  finished after removing " + count + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnSortedTimedoutItems(int maxCount) {
        int maxIndex = this.buckets.length;
        long idleThreshold = System.currentTimeMillis() - this.timeout;
        ArrayList<LruCache.LruCacheItem> victims = new ArrayList<LruCache.LruCacheItem>();
        int sz = 0;
        int totalSize = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimUnsortedTimedoutBeans started...");
        }
        for (int index = 0; index < maxIndex; ++index) {
            if (this.buckets[index] == null) continue;
            Object object = this.bucketLocks[index];
            synchronized (object) {
                for (BaseCache.CacheItem item = this.buckets[index]; item != null; item = item.getNext()) {
                    StatefulEJBContext ctx = (StatefulEJBContext)item.getValue();
                    if (ctx == null || ctx.getLastAccessTime() > idleThreshold || !ctx.canBePassivated()) continue;
                    LruCache.LruCacheItem litem = (LruCache.LruCacheItem)item;
                    LruSessionCache lruSessionCache = this;
                    synchronized (lruSessionCache) {
                        if (this.currentCacheState != 0) {
                            _logger.log(Level.WARNING, EXITING_TRIM_UNSORTED_TIMEDOUT_BEANS, new Object[]{this.cacheName, this.currentCacheState});
                            break;
                        }
                        if (!litem.isTrimmed()) {
                            this.itemRemoved((BaseCache.CacheItem)litem);
                            litem.setTrimmed(true);
                            victims.add(litem);
                        }
                        continue;
                    }
                }
            }
            sz = victims.size();
            if (sz < this.container.getPassivationBatchCount()) continue;
            this.trimSelectedVictims(victims);
            totalSize += sz;
            victims.clear();
        }
        sz = victims.size();
        if (sz > 0) {
            this.trimSelectedVictims(victims);
            totalSize += sz;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: TrimUnsortedTimedoutBeans  finished after removing " + totalSize + " idle beans");
        }
    }

    public int getNumVictimsAccessed() {
        return this.numVictimsAccessed;
    }

    protected BaseCache.CacheItem createItem(int hashCode, Object sessionKey, Object value, int size) {
        return new LruSessionCacheItem(hashCode, sessionKey, value, size);
    }

    public void setConfigData(String configData) {
        this.configData = configData;
    }

    @Override
    public void appendStats(StringBuilder sbuf) {
        sbuf.append("[Cache: ").append("Size=").append(this.entryCount).append("; ").append("HitCount=").append(this.hitCount).append("; ").append("MissCount=").append(this.missCount).append("; ").append("Passivations=").append(this.getNumPassivations()).append("; ");
        if (this.configData != null) {
            sbuf.append(this.configData);
        }
        sbuf.append("]");
    }

    @Override
    public int getCacheHits() {
        return this.hitCount;
    }

    @Override
    public int getCacheMisses() {
        return this.missCount;
    }

    @Override
    public int getNumBeansInCache() {
        return this.entryCount;
    }

    @Override
    public int getNumExpiredSessionsRemoved() {
        return 0;
    }

    @Override
    public int getNumPassivationErrors() {
        return 0;
    }

    @Override
    public int getNumPassivations() {
        return 0;
    }

    @Override
    public int getNumPassivationSuccess() {
        return 0;
    }

    public void setMaxCacheSize(int val) {
        this.confMaxCacheSize = val;
    }

    @Override
    public int getMaxCacheSize() {
        return this.confMaxCacheSize;
    }

    protected static class LruSessionCacheItem
    extends LruCache.LruCacheItem {
        protected byte waitCount;
        protected byte cacheItemState = 0;

        protected LruSessionCacheItem(int hashCode, Object key, Object value, int size) {
            super(hashCode, key, value, size);
            this.cacheItemState = 0;
        }

        protected LruSessionCacheItem(int hashCode, Object key, Object value, int size, byte state) {
            super(hashCode, key, value, size);
            this.cacheItemState = state;
        }
    }
}

