/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.faulttolerance.state;

import fish.payara.microprofile.faulttolerance.state.CircuitBreakerState;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicLong;

class StateTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CircuitBreakerState.CircuitState state;
    private ZonedDateTime since;
    private final AtomicLong nanos;

    StateTime(CircuitBreakerState.CircuitState state) {
        this.state = state;
        this.since = ZonedDateTime.now();
        this.nanos = new AtomicLong(0L);
    }

    CircuitBreakerState.CircuitState state() {
        return this.state;
    }

    boolean is(CircuitBreakerState.CircuitState state) {
        return this.state.equals((Object)state);
    }

    long nanos() {
        return this.nanos.get();
    }

    long update() {
        ZonedDateTime now = ZonedDateTime.now();
        long result = this.nanos.addAndGet(ChronoUnit.NANOS.between(this.since, now));
        this.since = now;
        return result;
    }

    void reset() {
        this.since = ZonedDateTime.now();
    }
}

