/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.store.strategy;

import fish.payara.notification.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.store.strategy.TraceStorageStrategy;
import java.util.Collection;
import java.util.Iterator;

public class LongestTraceStorageStrategy
implements TraceStorageStrategy {
    @Override
    public RequestTrace getTraceForRemoval(Collection<RequestTrace> traces, int maxSize, RequestTrace traceToRemove) {
        if (traces == null || traces.isEmpty() || traces.size() <= maxSize) {
            return null;
        }
        return traceToRemove != null && traces.contains(traceToRemove) ? traceToRemove : LongestTraceStorageStrategy.findShortestTrace(traces);
    }

    private static RequestTrace findShortestTrace(Collection<RequestTrace> traces) {
        Iterator<RequestTrace> iter = traces.iterator();
        RequestTrace shortest = iter.next();
        while (iter.hasNext()) {
            RequestTrace next = iter.next();
            if (next.getElapsedTime() >= shortest.getElapsedTime() && (next.getElapsedTime() != shortest.getElapsedTime() || !next.getStartTime().isBefore(shortest.getStartTime()))) continue;
            shortest = next;
        }
        return shortest;
    }
}

