/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.migration.finch;

import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

public class TransactionState
implements Serializable {
    static final long serialVersionUID = 4132677693277056907L;
    public static final int CREATED = 0;
    public static final int STARTED = 1;
    public static final int FAILED = 2;
    public static final int INCOMPLETE = 3;
    public static final int COMPLETE = 4;
    public static final int PREPARED = 5;
    public static final int COMMITTED = 6;
    public static final int ROLLEDBACK = 7;
    public static final int LAST = 7;
    private static final String[] names = new String[]{"CREATED", "STARTED", "FAILED", "INCOMPLETE", "COMPLETE", "PREPARED", "COMMITED", "ROLLEDBACK"};
    private JMQXid xid = null;
    private int state = 0;
    private String user = null;
    private String clientID = null;
    private String connectionString = null;

    public TransactionState() {
        this.state = 0;
    }

    public TransactionState(TransactionState ts) {
        this.xid = new JMQXid((Xid)ts.xid);
        this.state = ts.state;
        this.user = ts.user;
        this.clientID = ts.clientID;
        this.connectionString = ts.connectionString;
    }

    public Hashtable getDebugState() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("xid", this.xid == null ? "none" : this.xid.toString());
        ht.put("state", names[this.state]);
        ht.put("user", this.user == null ? "none" : this.user);
        ht.put("connectionString", this.connectionString == null ? "none" : this.connectionString);
        ht.put("clientID", this.clientID == null ? "none" : this.clientID);
        return ht;
    }

    public void setState(int state) throws BrokerException {
        if (state < 0 || state > 7) {
            throw new BrokerException("Illegal state " + state + ". Should be between " + 0 + " and " + 7 + " inclusive.");
        }
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setXid(JMQXid xid) {
        this.xid = xid;
    }

    public JMQXid getXid() {
        return this.xid;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setClientID(String id) {
        this.clientID = id;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setConnectionString(String s) {
        this.connectionString = s;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public int nextState(int pktType, Integer xaFlag) throws BrokerException {
        switch (pktType) {
            case 44: {
                if (!(TransactionState.isFlagSet(0, xaFlag) ? this.state == 0 || this.state == 4 || this.state == 1 : (TransactionState.isFlagSet(0x200000, xaFlag) ? this.state == 1 || this.state == 4 : TransactionState.isFlagSet(0x8000000, xaFlag) && (this.state == 3 || this.state == 1)))) break;
                return 1;
            }
            case 58: {
                if (TransactionState.isFlagSet(0x2000000, xaFlag)) {
                    if (this.state != 1 && this.state != 3) break;
                    return 3;
                }
                if (TransactionState.isFlagSet(0x20000000, xaFlag)) {
                    if (this.state != 1 && this.state != 3 && this.state != 2) break;
                    return 2;
                }
                if (!TransactionState.isFlagSet(0x4000000, xaFlag) && !TransactionState.isFlagSet(0x40000000, xaFlag) || this.state != 1 && this.state != 3 && this.state != 4) break;
                return 4;
            }
            case 56: {
                if (this.state != 4 && this.state != 5) break;
                return 5;
            }
            case 46: {
                if (!(TransactionState.isFlagSet(0x40000000, xaFlag) ? this.state == 4 || this.state == 6 : this.state == 5 || this.state == 6)) break;
                return 6;
            }
            case 48: {
                if (this.state == 4 || this.state == 3) {
                    return 7;
                }
                if (this.state == 5) {
                    return 7;
                }
                if (this.state != 2 && this.state != 7) break;
                return 7;
            }
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = PacketType.getString((int)pktType);
        objectArray[1] = TransactionState.xaFlagToString(xaFlag);
        objectArray[2] = TransactionState.toString(this.state);
        Object[] args = objectArray;
        throw new BrokerException(Globals.getBrokerResources().getString("B4132", args));
    }

    public static boolean isFlagSet(int flag, Integer xaFlags) {
        if (xaFlags == null) {
            return flag == 0;
        }
        if (flag == 0 || xaFlags == 0) {
            return flag == xaFlags;
        }
        return (xaFlags & flag) == flag;
    }

    public static String toString(int state) {
        if (state < 0 || state > 7) {
            return "UNKNOWN(" + state + ")";
        }
        return names[state] + "(" + state + ")";
    }

    public static String xaFlagToString(Integer flags) {
        StringBuffer sb = new StringBuffer("");
        boolean found = false;
        if (flags == null) {
            return "null";
        }
        sb.append("0x" + Integer.toHexString(flags) + ":");
        if (TransactionState.isFlagSet(0, flags)) {
            sb.append("TMNOFLAGS");
            return sb.toString();
        }
        if (TransactionState.isFlagSet(0x800000, flags)) {
            sb.append("TMENDRSCAN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x20000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMFAIL");
            found = true;
        }
        if (TransactionState.isFlagSet(0x200000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMJOIN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x40000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMONEPHASE");
            found = true;
        }
        if (TransactionState.isFlagSet(0x8000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMRESUME");
            found = true;
        }
        if (TransactionState.isFlagSet(0x1000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSTARTSCAN");
            found = true;
        }
        if (TransactionState.isFlagSet(0x4000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSUCCESS");
            found = true;
        }
        if (TransactionState.isFlagSet(0x2000000, flags)) {
            if (found) {
                sb.append("|");
            }
            sb.append("TMSUSPEND");
            found = true;
        }
        if (!found) {
            sb.append("???");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.xid == null) {
            return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state);
        }
        return this.user + "@" + this.clientID + ":" + TransactionState.toString(this.state) + ":xid=" + this.xid.toString();
    }

    public Object readResolve() throws ObjectStreamException {
        try {
            com.sun.messaging.jmq.jmsserver.data.TransactionState obj = new com.sun.messaging.jmq.jmsserver.data.TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
            obj.setXid(this.xid);
            obj.setState(this.state);
            obj.setUser(this.user);
            obj.setClientID(this.clientID);
            obj.setConnectionString(this.connectionString);
            return obj;
        }
        catch (BrokerException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

