/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import com.sun.enterprise.admin.report.ActionReporter;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.admin.rest.utils.JsonUtil;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ActionReportJsonProvider
extends BaseProvider<ActionReporter> {
    public ActionReportJsonProvider() {
        super(ActionReporter.class, MediaType.APPLICATION_JSON_TYPE);
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    @Override
    public String getContent(ActionReporter ar) {
        String JsonP = this.getCallBackJSONP();
        try {
            JsonObject result = this.processReport(ar);
            if (JsonP == null) {
                return result.toString();
            }
            return JsonP + "(" + result.toString() + ")";
        }
        catch (JsonException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected JsonObject processReport(ActionReporter ar) throws JsonException {
        List subReports;
        List children;
        Properties extraProperties;
        JsonObjectBuilder result = Json.createObjectBuilder();
        if (ar instanceof RestActionReporter) {
            result.add("message", ((RestActionReporter)ar).getCombinedMessage());
        } else {
            String message = this.decodeEol(ar.getMessage());
            if (message != null) {
                result.add("message", message);
            }
        }
        String desc = ar.getActionDescription();
        if (desc != null) {
            result.add("command", ar.getActionDescription());
        } else {
            result.add("command", JsonValue.NULL);
        }
        result.add("exit_code", ar.getActionExitCode().toString());
        Properties properties = ar.getTopMessagePart().getProps();
        if (properties != null && !properties.isEmpty()) {
            JsonObject propBuilder = Json.createObjectBuilder((Map)properties).build();
            result.add("properties", (JsonValue)propBuilder);
        }
        if ((extraProperties = ar.getExtraProperties()) != null && !extraProperties.isEmpty()) {
            result.add("extraProperties", (JsonValue)this.getExtraProperties(extraProperties));
        }
        if ((children = ar.getTopMessagePart().getChildren()) != null && !children.isEmpty()) {
            result.add("children", (JsonValue)this.processChildren(children));
        }
        if ((subReports = ar.getSubActionsReport()) != null && !subReports.isEmpty()) {
            result.add("subReports", (JsonValue)this.processSubReports(subReports));
        }
        return result.build();
    }

    protected JsonArray processChildren(List<ActionReport.MessagePart> parts) throws JsonException {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (ActionReport.MessagePart part : parts) {
            JsonObjectBuilder object = Json.createObjectBuilder();
            String message = this.decodeEol(part.getMessage());
            if (message != null) {
                object.add("message", this.decodeEol(part.getMessage()));
            } else {
                object.add("message", JsonValue.NULL);
            }
            object.add("properties", (JsonValue)Json.createObjectBuilder((Map)part.getProps()).build());
            List children = part.getChildren();
            if (!children.isEmpty()) {
                object.add("children", (JsonValue)this.processChildren(part.getChildren()));
            }
            array.add((JsonValue)object.build());
        }
        return array.build();
    }

    protected JsonArray processSubReports(List<ActionReporter> subReports) throws JsonException {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (ActionReporter subReport : subReports) {
            array.add((JsonValue)this.processReport(subReport));
        }
        return array.build();
    }

    protected JsonObject getExtraProperties(Properties props) throws JsonException {
        JsonObjectBuilder extraProperties = Json.createObjectBuilder();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString();
            JsonValue value = JsonUtil.getJsonValue(entry.getValue());
            extraProperties.add(key, JsonUtil.getJsonValue(value));
        }
        return extraProperties.build();
    }

    protected <T> T getFieldValue(final ActionReporter ar, final String name, T type) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object value = null;
                try {
                    Class<?> clazz = ar.getClass().getSuperclass();
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    value = field.get(ar);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return value;
            }
        });
    }

    protected String decodeEol(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("%%%EOL%%%", "\n");
    }
}

