/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.openapi.impl.model.media;

import fish.payara.microprofile.openapi.api.visitor.ApiContext;
import fish.payara.microprofile.openapi.impl.model.examples.ExampleImpl;
import fish.payara.microprofile.openapi.impl.model.media.EncodingImpl;
import fish.payara.microprofile.openapi.impl.model.media.MediaTypeImpl;
import fish.payara.microprofile.openapi.impl.model.media.SchemaImpl;
import fish.payara.microprofile.openapi.impl.model.util.ModelUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;

public class ContentImpl
extends LinkedHashMap<String, MediaType>
implements Content {
    private static final long serialVersionUID = 1575356277308242221L;

    public ContentImpl() {
    }

    public ContentImpl(Map<? extends String, ? extends MediaType> items) {
        super(items);
    }

    public static ContentImpl createInstance(AnnotationModel annotation, ApiContext context) {
        ContentImpl from = new ContentImpl();
        String typeName = (String)annotation.getValue("mediaType", String.class);
        if (typeName == null || typeName.isEmpty()) {
            typeName = "*/*";
        }
        MediaTypeImpl mediaType = new MediaTypeImpl();
        from.addMediaType(typeName, mediaType);
        ModelUtils.extractAnnotations(annotation, context, "examples", "name", ExampleImpl::createInstance, (arg_0, arg_1) -> ((MediaType)mediaType).addExample(arg_0, arg_1));
        mediaType.setExample(annotation.getValue("example", String.class));
        AnnotationModel schemaAnnotation = (AnnotationModel)annotation.getValue("schema", AnnotationModel.class);
        if (schemaAnnotation != null) {
            mediaType.setSchema(SchemaImpl.createInstance(schemaAnnotation, context));
        }
        ModelUtils.extractAnnotations(annotation, context, "encoding", "name", EncodingImpl::createInstance, (arg_0, arg_1) -> ((MediaType)mediaType).addEncoding(arg_0, arg_1));
        return from;
    }

    public ContentImpl addMediaType(String name, MediaType item) {
        if (item != null) {
            this.put(name, item);
        }
        return this;
    }

    public void removeMediaType(String name) {
        this.remove(name);
    }

    public Map<String, MediaType> getMediaTypes() {
        return ModelUtils.readOnlyView(this);
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        this.clear();
        this.putAll(mediaTypes);
    }

    public static void merge(ContentImpl from, Content to, boolean override, ApiContext context) {
        if (from == null) {
            return;
        }
        for (Map.Entry<String, MediaType> fromEntry : from.getMediaTypes().entrySet()) {
            String typeName = fromEntry.getKey();
            MediaType fromMediaType = fromEntry.getValue();
            MediaTypeImpl toMediaType = to.getMediaTypes().getOrDefault(typeName, new MediaTypeImpl());
            to.addMediaType(typeName, (MediaType)toMediaType);
            for (Map.Entry encoding : fromMediaType.getEncoding().entrySet()) {
                EncodingImpl.merge((String)encoding.getKey(), (Encoding)encoding.getValue(), toMediaType.encoding, override, context);
            }
            for (Map.Entry example : fromMediaType.getExamples().entrySet()) {
                ExampleImpl.merge((String)example.getKey(), (Example)example.getValue(), toMediaType.examples, override);
            }
            toMediaType.setExample(ModelUtils.mergeProperty(toMediaType.getExample(), fromMediaType.getExample(), override));
            if (fromMediaType.getSchema() == null) continue;
            if (toMediaType.getSchema() == null) {
                toMediaType.setSchema(new SchemaImpl());
            }
            Schema schema = toMediaType.getSchema();
            SchemaImpl.merge(fromMediaType.getSchema(), schema, true, context);
        }
    }
}

