/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm;

import com.sun.enterprise.admin.report.PlainTextActionReporter;
import com.sun.enterprise.v3.admin.InserverCommandRunnerHelper;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.el.ELProcessor;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.Config;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.EmbeddedSystemAdministrator;
import org.glassfish.internal.api.Globals;

public interface RealmUtil {
    public static final String JAAS_CONTEXT = "jaas-context";
    public static final String ASSIGN_GROUPS = "assign-groups";

    public static <T> T getConfiguredValue(Class<T> type, T value, Config provider, String mpConfigKey) {
        Object result = value;
        Optional<T> configResult = provider.getOptionalValue(mpConfigKey, type);
        if (configResult.isPresent()) {
            return configResult.get();
        }
        if (type == String.class) {
            result = TranslatedConfigView.expandValue((String)((String)result));
        }
        if (type == String.class && RealmUtil.isELExpression((String)value)) {
            ELProcessor elProcessor = new ELProcessor();
            BeanManager beanManager = CDI.current().getBeanManager();
            elProcessor.getELManager().addELResolver(beanManager.getELResolver());
            result = elProcessor.getValue(RealmUtil.toRawExpression((String)result), type);
        }
        return result;
    }

    public static boolean isELExpression(String expression) {
        return !expression.isEmpty() && RealmUtil.isDeferredExpression(expression);
    }

    public static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    public static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    public static void createAuthRealm(String name, String realmClass, String loginModule, Properties props) {
        PlainTextActionReporter report;
        ActionReport outreport;
        ServiceLocator serviceLocator = Globals.getDefaultHabitat();
        InserverCommandRunnerHelper commandRunnerHelper = (InserverCommandRunnerHelper)serviceLocator.getService(InserverCommandRunnerHelper.class, new Annotation[0]);
        EmbeddedSystemAdministrator administrator = (EmbeddedSystemAdministrator)serviceLocator.getService(EmbeddedSystemAdministrator.class, new Annotation[0]);
        ParameterMap parameters = new ParameterMap();
        parameters.insert("authrealmname", name);
        parameters.insert("property", props.entrySet().stream().map(prop -> RealmUtil.escapeRealmProperty(prop.getKey().toString()) + '=' + RealmUtil.escapeRealmProperty(prop.getValue().toString())).collect(Collectors.joining(":")));
        parameters.insert("classname", realmClass);
        if (loginModule != null) {
            parameters.insert("login-module", loginModule);
        }
        if ((outreport = commandRunnerHelper.runCommand("create-auth-realm", parameters, (ActionReport)(report = new PlainTextActionReporter()), administrator.getSubject())).getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            throw new IllegalStateException("Error in creating Auth realm: " + name);
        }
    }

    public static String escapeRealmProperty(String component) {
        return component.replaceAll("\\:", "\\\\:").replaceAll("\\=", "\\\\=");
    }
}

