/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source.extension;

import fish.payara.nucleus.microprofile.config.source.extension.ConfigSourceExtensions;
import fish.payara.nucleus.microprofile.config.source.extension.ConfiguredExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSource;
import fish.payara.nucleus.microprofile.config.source.extension.proxy.ConfigSourceProxy;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import org.glassfish.hk2.api.ServiceHandle;

public class ExtensionConfigSourceHandler {
    private final ExtensionConfigSource configSource;
    private final ConfigSourceProxy proxyConfigSource;
    private final Class<ConfigSourceConfiguration> configClass;
    private final String configSourceName;
    private ConfigSourceConfiguration config;

    public ExtensionConfigSourceHandler(ServiceHandle<ExtensionConfigSource> configSourceHandle) {
        this(configSourceHandle, null, null);
    }

    public ExtensionConfigSourceHandler(ServiceHandle<ExtensionConfigSource> configSourceHandle, Class<ConfigSourceConfiguration> configClass, ConfigSourceConfiguration config) {
        this.configSource = configSourceHandle.getService();
        this.configSourceName = ConfigSourceExtensions.getName(configSourceHandle);
        this.configClass = configClass;
        this.config = config;
        this.proxyConfigSource = new ConfigSourceProxy(this.configSourceName);
    }

    public Class<ConfigSourceConfiguration> getConfigClass() {
        return this.configClass;
    }

    protected String getName() {
        return this.configSourceName;
    }

    protected void reconfigure(ConfigSourceConfiguration config) {
        boolean wasEnabled;
        this.config = config;
        Object currentConfig = ((ConfiguredExtensionConfigSource)ConfiguredExtensionConfigSource.class.cast(this.configSource)).getConfiguration();
        boolean enabled = config != null && Boolean.valueOf(config.getEnabled()) != false;
        boolean bl = wasEnabled = currentConfig != null && Boolean.valueOf(currentConfig.getEnabled()) != false;
        if (!enabled) {
            if (wasEnabled) {
                this.destroy();
            }
        } else if (wasEnabled) {
            this.destroy();
            this.bootstrap();
        } else {
            this.bootstrap();
        }
    }

    protected synchronized void destroy() {
        boolean wasEnabled = this.isEnabled();
        if (this.configClass != null) {
            ((ConfiguredExtensionConfigSource)ConfiguredExtensionConfigSource.class.cast(this.configSource)).setConfiguration(this.config);
        }
        if (wasEnabled) {
            this.proxyConfigSource.setDelegate(null);
            this.configSource.destroy();
        }
    }

    protected synchronized void bootstrap() {
        if (this.configClass != null) {
            ((ConfiguredExtensionConfigSource)ConfiguredExtensionConfigSource.class.cast(this.configSource)).setConfiguration(this.config);
        }
        if (this.isEnabled()) {
            this.configSource.bootstrap();
            this.proxyConfigSource.setDelegate(this.configSource);
        }
    }

    public ConfigSourceProxy getProxyConfigSource() {
        return this.proxyConfigSource;
    }

    private boolean isEnabled() {
        if (this.configClass != null) {
            Object config = ((ConfiguredExtensionConfigSource)ConfiguredExtensionConfigSource.class.cast(this.configSource)).getConfiguration();
            if (config == null) {
                return false;
            }
            return config != null && Boolean.valueOf(config.getEnabled()) != false;
        }
        return true;
    }
}

