/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.ibm.jbatch.spi.TaggedJobExecution;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.jbatch.persistence.rdbms.DB2PersistenceManager;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.MySqlPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.OraclePersistenceManager;
import fish.payara.jbatch.persistence.rdbms.PostgresPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.SQLServerPersistenceManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobExecution;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.validation.constraints.Min;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommand;
import org.glassfish.batch.AbstractLongListCommand;
import org.glassfish.batch.spi.impl.BatchRuntimeConfiguration;
import org.glassfish.batch.spi.impl.BatchRuntimeHelper;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_ListBatchJobs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="_ListBatchJobs")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="_ListBatchJobs", description="_List Batch Jobs")})
public class ListBatchJobs
extends AbstractLongListCommand {
    private static final String JOB_NAME = "jobName";
    private static final String APP_NAME = "appName";
    private static final String INSTANCE_COUNT = "instanceCount";
    private static final String INSTANCE_ID = "instanceId";
    private static final String EXECUTION_ID = "executionId";
    private static final String BATCH_STATUS = "batchStatus";
    private static final String EXIT_STATUS = "exitStatus";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    @Param(primary=true, optional=true)
    String jobName;
    @Min(value=0L, message="Offset value needs to be greater than 0")
    @Param(name="offset", optional=true, defaultValue="0")
    @Min(value=0L, message="Offset value needs to be greater than 0") String offSetValue;
    @Min(value=0L, message="Limit value needs to be greater than 0")
    @Param(name="limit", optional=true, defaultValue="2000")
    @Min(value=0L, message="Limit value needs to be greater than 0") String limitValue;
    @Inject
    BatchRuntimeHelper batchRuntimeHelper;
    @Inject
    BatchRuntimeConfiguration batchRuntimeConfiguration;
    private DataSource dataSource;
    private String jobInstanceTableKey;
    private String queryToGetUniqueJobNames;

    @Override
    protected void executeCommand(AdminCommandContext context, Properties extraProps) throws Exception {
        InitialContext ctx = new InitialContext();
        String dataSourceName = this.batchRuntimeHelper.getDataSourceLookupName();
        Object object = ctx.lookup(dataSourceName);
        if (object instanceof DataSource) {
            this.dataSource = (DataSource)DataSource.class.cast(object);
            String prefix = this.batchRuntimeConfiguration.getTablePrefix();
            String suffix = this.batchRuntimeConfiguration.getTableSuffix();
            this.createTables();
            this.jobInstanceTableKey = prefix + "JOBINSTANCEDATA" + suffix;
            if (this.checkIfTableExists(this.jobInstanceTableKey)) {
                this.queryToGetUniqueJobNames = "SELECT DISTINCT name FROM " + this.jobInstanceTableKey;
                ColumnFormatter columnFormatter = new ColumnFormatter(this.getDisplayHeaders());
                if (this.isSimpleMode()) {
                    this.setToSimpleMode(extraProps, columnFormatter);
                } else {
                    this.setToLongMode(extraProps, columnFormatter);
                }
                context.getActionReport().setMessage(columnFormatter.toString());
            } else {
                context.getActionReport().failure(this.logger, this.jobInstanceTableKey + " table doesn't exists");
            }
        }
    }

    private void setToSimpleMode(Properties extraProps, ColumnFormatter columnFormatter) {
        extraProps.put("simpleMode", (Object)true);
        HashMap<String, Integer> jobsInstanceCount = new HashMap<String, Integer>();
        if (this.jobName != null) {
            jobsInstanceCount.put(this.jobName, this.getJobInstanceCount(this.jobName));
        } else {
            List<String> jobNames = this.executeQuery(this.queryToGetUniqueJobNames, "name");
            for (String job_Name : jobNames) {
                jobsInstanceCount.put(job_Name, this.getJobInstanceCount(job_Name));
            }
        }
        extraProps.put("listBatchJobs", this.findSimpleJobInfo(jobsInstanceCount, columnFormatter));
    }

    private void setToLongMode(Properties extraProps, ColumnFormatter columnFormatter) {
        extraProps.put("simpleMode", (Object)false);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("allJobsCount", this.getAllJobInstanceCount());
        extraProps.put("listJobsCount", map);
        ArrayList<Map<String, Object>> jobExecutions = new ArrayList<Map<String, Object>>();
        extraProps.put("listBatchJobs", jobExecutions);
        HashMap<String, Integer> jobsInstanceCount = new HashMap<String, Integer>();
        if (Arrays.asList(this.getOutputHeaders()).contains(INSTANCE_COUNT)) {
            List<String> jobNames = this.executeQuery(this.queryToGetUniqueJobNames, "name");
            for (String job_Name : jobNames) {
                jobsInstanceCount.put(job_Name, this.getJobInstanceCount(job_Name));
            }
        }
        List<Long> jobInstanceIDs = this.getJobInstanceIDs();
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        for (Long jobExecution : jobInstanceIDs) {
            try {
                if (!this.glassFishBatchSecurityHelper.isVisibleToThisInstance(((TaggedJobExecution)jobOperator.getJobExecution(jobExecution)).getTagName())) continue;
                jobExecutions.add(this.handleJob(jobOperator.getJobExecution(jobExecution), columnFormatter, jobsInstanceCount));
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception while getting jobExecution details: " + ex);
                this.logger.log(Level.FINE, "Exception while getting jobExecution details ", ex);
            }
        }
    }

    private boolean checkIfTableExists(String tableName) {
        boolean result = true;
        String schema = this.batchRuntimeConfiguration.getSchemaName();
        try (Connection connection = this.dataSource.getConnection();){
            String database = connection.getMetaData().getDatabaseProductName();
            if (database.contains("H2")) {
                JBatchJDBCPersistenceManager jBatchJDBCPersistenceManager = new JBatchJDBCPersistenceManager();
                result = jBatchJDBCPersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            } else if (database.contains("MySQL")) {
                MySqlPersistenceManager mySqlPersistenceManager = new MySqlPersistenceManager();
                result = mySqlPersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            } else if (database.contains("Oracle")) {
                OraclePersistenceManager oraclePersistenceManager = new OraclePersistenceManager();
                result = oraclePersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            } else if (database.contains("PostgreSQL")) {
                PostgresPersistenceManager postgresPersistenceManager = new PostgresPersistenceManager();
                result = postgresPersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            } else if (database.contains("DB2")) {
                DB2PersistenceManager dB2PersistenceManager = new DB2PersistenceManager();
                result = dB2PersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            } else if (database.contains("Microsoft SQL Server")) {
                SQLServerPersistenceManager sQLServerPersistenceManager = new SQLServerPersistenceManager();
                result = sQLServerPersistenceManager.checkIfTableExists(this.dataSource, tableName, schema);
            }
        }
        catch (SQLException e) {
            this.logger.severe(e.getLocalizedMessage());
        }
        return result;
    }

    private void createTables() {
        try (Connection connection = this.dataSource.getConnection();){
            String database = connection.getMetaData().getDatabaseProductName();
            if (database.contains("H2")) {
                JBatchJDBCPersistenceManager jBatchJDBCPersistenceManager = new JBatchJDBCPersistenceManager();
                jBatchJDBCPersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            } else if (database.contains("MySQL")) {
                MySqlPersistenceManager mySqlPersistenceManager = new MySqlPersistenceManager();
                mySqlPersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            } else if (database.contains("Oracle")) {
                OraclePersistenceManager oraclePersistenceManager = new OraclePersistenceManager();
                oraclePersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            } else if (database.contains("PostgreSQL")) {
                PostgresPersistenceManager postgresPersistenceManager = new PostgresPersistenceManager();
                postgresPersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            } else if (database.contains("DB2")) {
                DB2PersistenceManager dB2PersistenceManager = new DB2PersistenceManager();
                dB2PersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            } else if (database.contains("Microsoft SQL Server")) {
                SQLServerPersistenceManager sQLServerPersistenceManager = new SQLServerPersistenceManager();
                sQLServerPersistenceManager.createTables(this.dataSource, this.batchRuntimeConfiguration);
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
    }

    private int getJobInstanceCount(String jobName) {
        int jobInstanceCount = 0;
        try (Connection connection = this.dataSource.getConnection();){
            String query = "SELECT COUNT(jobinstanceid) AS jobinstancecount FROM " + this.jobInstanceTableKey + " WHERE NAME =?";
            try (PreparedStatement preparedStatement = connection.prepareStatement(query);){
                preparedStatement.setString(1, jobName);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    resultSet.next();
                    jobInstanceCount = resultSet.getInt("jobinstancecount");
                }
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
        return jobInstanceCount;
    }

    private int getAllJobInstanceCount() {
        int allJobInstanceCount = 0;
        try (Connection connection = this.dataSource.getConnection();){
            String query = "SELECT COUNT(jobinstanceid) AS jobinstancecount FROM " + this.jobInstanceTableKey;
            try (PreparedStatement prepareStatement = connection.prepareStatement(query);
                 ResultSet resultSet = prepareStatement.executeQuery();){
                resultSet.next();
                allJobInstanceCount = resultSet.getInt("jobinstancecount");
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
        return allJobInstanceCount;
    }

    private List<Long> getJobInstanceIDs() {
        List<Long> result = new ArrayList<Long>();
        try (Connection connection = this.dataSource.getConnection();){
            String database = connection.getMetaData().getDatabaseProductName();
            if (database.contains("Derby") || database.contains("DB2")) {
                if (this.jobName != null) {
                    String query = "SELECT jobinstanceid FROM JOBINSTANCEDATA WHERE NAME = ? ORDER BY jobinstanceid DESC FETCH FIRST ? ROWS ONLY";
                    result = this.queryToGetInstanceIDs(query, this.jobName, this.limitValue);
                } else {
                    String query = "SELECT jobinstanceid FROM JOBINSTANCEDATA ORDER BY jobinstanceid DESC OFFSET ? ROWS FETCH FIRST ? ROWS ONLY";
                    result = this.queryToGetInstanceIDs(query, this.offSetValue, this.limitValue);
                }
            } else if (database.contains("Oracle")) {
                if (this.jobName != null) {
                    String query = "SELECT jobinstanceid FROM (SELECT jobinstanceid FROM " + this.jobInstanceTableKey + " WHERE NAME =?) WHERE ROWNUM <=? ORDER BY jobinstanceid DESC";
                    result = this.queryToGetInstanceIDs(query, this.jobName, this.limitValue);
                } else {
                    int offset = Integer.parseInt(this.offSetValue);
                    int limit = Integer.parseInt(this.limitValue);
                    int rowSize = offset + limit;
                    String query = "SELECT jobinstanceid FROM (SELECT ROWNUM numofrows, tables.* FROM(SELECT jobinstanceid FROM " + this.jobInstanceTableKey + " ORDER BY jobinstanceid DESC) tables WHERE ROWNUM <=?) WHERE numofrows >?";
                    result = this.queryToGetInstanceIDs(query, String.valueOf(rowSize), this.offSetValue);
                }
            } else if (database.contains("Microsoft SQL Server")) {
                if (this.jobName != null) {
                    String query = "SELECT TOP ? jobinstanceid FROM " + this.jobInstanceTableKey + " WHERE NAME =? ORDER BY jobinstanceid DESC";
                    result = this.queryToGetInstanceIDs(query, this.limitValue, this.jobName);
                } else {
                    String query = "SELECT TOP ? jobinstanceid FROM (SELECT jobinstanceid, ROW_NUMBER() OVER (ORDER BY jobinstanceid DESC) as RowNum FROM " + this.jobInstanceTableKey + ") AS MyDerivedTable WHERE MyDerivedTable.RowNum > ?";
                    result = this.queryToGetInstanceIDs(query, this.limitValue, this.offSetValue);
                }
            } else if (this.jobName != null) {
                String query = "SELECT jobinstanceid FROM " + this.jobInstanceTableKey + " WHERE NAME = ?  ORDER BY jobinstanceid DESC LIMIT ?";
                result = this.queryToGetInstanceIDs(query, this.jobName, this.limitValue);
            } else {
                String query = "SELECT jobinstanceid FROM " + this.jobInstanceTableKey + " ORDER BY jobinstanceid DESC LIMIT ? OFFSET ?";
                result = this.queryToGetInstanceIDs(query, this.limitValue, this.offSetValue);
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    @Override
    protected final String[] getAllHeaders() {
        return new String[]{JOB_NAME, APP_NAME, INSTANCE_COUNT, INSTANCE_ID, EXECUTION_ID, BATCH_STATUS, START_TIME, END_TIME, EXIT_STATUS};
    }

    @Override
    protected final String[] getDefaultHeaders() {
        return new String[]{JOB_NAME, INSTANCE_COUNT};
    }

    private boolean isSimpleMode() {
        for (String outputHeader : this.getOutputHeaders()) {
            if (JOB_NAME.equals(outputHeader) || INSTANCE_COUNT.equals(outputHeader)) continue;
            return false;
        }
        return this.getOutputHeaders().length == 2;
    }

    private Map<String, Integer> findSimpleJobInfo(Map<String, Integer> jobToInstanceCountMap, ColumnFormatter columnFormatter) {
        for (Map.Entry<String, Integer> e : jobToInstanceCountMap.entrySet()) {
            columnFormatter.addRow(new Object[]{e.getKey(), e.getValue()});
        }
        return jobToInstanceCountMap;
    }

    private Map<String, Object> handleJob(JobExecution jobExecution, ColumnFormatter columnFormatter, Map<String, Integer> jobInstanceCount) throws JobSecurityException, NoSuchJobException, NoSuchJobExecutionException {
        HashMap<String, Object> jobInfo = new HashMap<String, Object>();
        Object[] columnFormatterData = new String[this.getOutputHeaders().length];
        JobOperator jobOperator = AbstractListCommand.getJobOperatorFromBatchRuntime();
        for (int index = 0; index < this.getOutputHeaders().length; ++index) {
            Object data = null;
            switch (this.getOutputHeaders()[index]) {
                case "jobName": {
                    data = "" + jobExecution.getJobName();
                    break;
                }
                case "appName": {
                    try {
                        String appName = "" + ((TaggedJobExecution)jobExecution).getTagName();
                        int semi = appName.indexOf(58);
                        data = appName.substring(semi + 1);
                    }
                    catch (Exception ex) {
                        this.logger.log(Level.FINE, "Error while calling ((TaggedJobExecution) je).getTagName() ", ex);
                        data = ex.toString();
                    }
                    break;
                }
                case "instanceCount": {
                    data = jobInstanceCount.size() > 0 ? jobInstanceCount.get(jobExecution.getJobName()) : "";
                    break;
                }
                case "instanceId": {
                    data = jobOperator.getJobInstance(jobExecution.getExecutionId()).getInstanceId();
                    break;
                }
                case "executionId": {
                    data = jobExecution.getExecutionId();
                    break;
                }
                case "batchStatus": {
                    data = jobExecution.getBatchStatus() != null ? jobExecution.getBatchStatus() : "";
                    break;
                }
                case "exitStatus": {
                    data = jobExecution.getExitStatus() != null ? jobExecution.getExitStatus() : "";
                    break;
                }
                case "startTime": {
                    if (jobExecution.getStartTime() != null) {
                        data = jobExecution.getStartTime().getTime();
                        columnFormatterData[index] = jobExecution.getStartTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                case "endTime": {
                    if (jobExecution.getEndTime() != null) {
                        data = jobExecution.getEndTime().getTime();
                        columnFormatterData[index] = jobExecution.getEndTime().toString();
                        break;
                    }
                    data = "";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown header: " + this.getOutputHeaders()[index]);
                }
            }
            jobInfo.put(this.getOutputHeaders()[index], data);
            if (columnFormatterData[index] != null) continue;
            columnFormatterData[index] = data.toString();
        }
        columnFormatter.addRow(columnFormatterData);
        return jobInfo;
    }

    private List<Long> queryToGetInstanceIDs(String query, String parameter1, String parameter2) {
        ArrayList<Long> result = new ArrayList<Long>();
        String columnID = "jobinstanceid";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);){
            preparedStatement.setInt(1, Integer.parseInt(parameter1));
            preparedStatement.setInt(2, Integer.parseInt(parameter2));
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getLong(columnID));
                }
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }

    private List<String> executeQuery(String query, String columnID) {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(query);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                result.add(resultSet.getString(columnID));
            }
        }
        catch (SQLException ex) {
            this.logger.severe(ex.getLocalizedMessage());
        }
        return result;
    }
}

