/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.oauth2;

import fish.payara.security.annotations.OAuth2AuthenticationDefinition;
import fish.payara.security.oauth2.OAuth2Client;
import fish.payara.security.oauth2.OAuth2StateHolder;
import fish.payara.security.oauth2.api.OAuth2State;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELProcessor;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.AutoApplySession;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;
import javax.security.enterprise.credential.RememberMeCredential;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStoreHandler;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.config.support.TranslatedConfigView;

@AutoApplySession
@Typed(value={OAuth2AuthenticationMechanism.class})
public class OAuth2AuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger logger = Logger.getLogger("OAuth2Mechanism");
    private final ELProcessor elProcessor = new ELProcessor();
    private String authEndpoint;
    private String tokenEndpoint;
    private String clientID;
    private char[] clientSecret;
    private String redirectURI;
    private String scopes;
    private String[] extraParameters;
    @Inject
    private OAuth2State state;
    @Inject
    private OAuth2StateHolder tokenHolder;
    @Inject
    private IdentityStoreHandler identityStoreHandler;

    public OAuth2AuthenticationMechanism() {
        BeanManager beanManager = CDI.current().getBeanManager();
        this.elProcessor.getELManager().addELResolver(beanManager.getELResolver());
    }

    public OAuth2AuthenticationMechanism(OAuth2AuthenticationDefinition definition) {
        this();
        this.setDefinition(definition);
    }

    public OAuth2AuthenticationMechanism setDefinition(OAuth2AuthenticationDefinition definition) {
        Config provider = ConfigProvider.getConfig();
        this.authEndpoint = this.getConfiguredValue(definition.authEndpoint(), provider, "payara.security.oauth2.authEndpoint");
        this.tokenEndpoint = this.getConfiguredValue(definition.tokenEndpoint(), provider, "payara.security.oauth2.tokenEndpoint");
        this.clientID = this.getConfiguredValue(definition.clientId(), provider, "payara.security.oauth2.clientId");
        this.clientSecret = this.getConfiguredValue(definition.clientSecret(), provider, "payara.security.oauth2.clientSecret").toCharArray();
        this.redirectURI = this.getConfiguredValue(definition.redirectURI(), provider, "payara.security.oauth2.redirectURI");
        this.scopes = this.getConfiguredValue(definition.scope(), provider, "payara.security.oauth2.scope");
        String[] params = definition.extraParameters();
        this.extraParameters = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.extraParameters[i] = this.getConfiguredValue(params[i], provider, params[i]);
        }
        return this;
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (httpMessageContext.isProtected() && request.getUserPrincipal() == null) {
            return this.redirectForAuth(httpMessageContext);
        }
        String recievedState = request.getParameter("state");
        if (request.getRequestURL().toString().equals(this.redirectURI) && recievedState != null) {
            if (recievedState.equals(this.state.getState())) {
                return this.validateCallback(request, httpMessageContext);
            }
            logger.log(Level.FINE, "Inconsistent recieved state. This may be caused by using the back button in the browser.");
            return httpMessageContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
        }
        logger.log(Level.FINEST, "Authentication mechanism doing nothing");
        return httpMessageContext.doNothing();
    }

    private AuthenticationStatus validateCallback(HttpServletRequest request, HttpMessageContext context) {
        logger.log(Level.FINER, "User Authenticated, now getting authorisation token");
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "authorization_code");
        formData.put("client_id", this.clientID);
        formData.put("client_secret", new String(this.clientSecret));
        formData.put("code", request.getParameter("code"));
        formData.put("state", this.state.getState());
        if (this.redirectURI != null && !this.redirectURI.isEmpty()) {
            formData.put("redirect_uri", this.redirectURI);
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            formData.put("scope", this.scopes);
        }
        for (String extra : this.extraParameters) {
            String[] parts = extra.split("=");
            formData.put(parts[0], parts[1]);
        }
        OAuth2Client client = new OAuth2Client(this.tokenEndpoint, request.getRequestURL().toString(), formData);
        Response response = client.authenticate();
        String resultString = (String)response.readEntity(String.class);
        JsonObject result = this.readJsonObject(resultString);
        logger.log(Level.FINEST, "Response code from endpoint: {0}", response.getStatus());
        if (response.getStatus() != 200) {
            String error = result.getString("error", "Unknown Error");
            String errorDescription = result.getString("error_description", "Unknown");
            logger.log(Level.WARNING, "[OAUTH-001] Error occurred authenticating user: {0} caused by {1}", new Object[]{error, errorDescription});
            return context.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
        }
        this.tokenHolder.setAccessToken(result.getString("access_token"));
        this.tokenHolder.setRefreshToken(result.getString("refresh_token", null));
        this.tokenHolder.setScope(result.getString("scope", null));
        JsonNumber expiresIn = result.getJsonNumber("expires_in");
        if (expiresIn != null) {
            this.tokenHolder.setExpiresIn(expiresIn.longValue());
        }
        RememberMeCredential credential = new RememberMeCredential(resultString);
        CredentialValidationResult validationResult = this.identityStoreHandler.validate((Credential)credential);
        return context.notifyContainerAboutLogin(validationResult);
    }

    private JsonObject readJsonObject(String result) {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(result));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    private AuthenticationStatus redirectForAuth(HttpMessageContext context) {
        logger.log(Level.FINEST, "Redirecting for authentication to {0}", this.authEndpoint);
        StringBuilder authTokenRequest = new StringBuilder(this.authEndpoint);
        authTokenRequest.append("?client_id=").append(this.clientID);
        authTokenRequest.append("&state=").append(this.state.getState());
        authTokenRequest.append("&response_type=code");
        if (this.redirectURI != null && !this.redirectURI.isEmpty()) {
            authTokenRequest.append("&redirect_uri=").append(this.redirectURI);
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            authTokenRequest.append("&scope=").append(this.scopes);
        }
        for (String extra : this.extraParameters) {
            authTokenRequest.append("&").append(extra);
        }
        return context.redirect(authTokenRequest.toString());
    }

    private String getConfiguredValue(String value, Config provider, String mpConfigKey) {
        String result = value;
        Optional configResult = provider.getOptionalValue(mpConfigKey, String.class);
        if (configResult.isPresent()) {
            return (String)configResult.get();
        }
        result = TranslatedConfigView.expandValue((String)result);
        if (OAuth2AuthenticationMechanism.isELExpression(value)) {
            result = (String)this.elProcessor.getValue(OAuth2AuthenticationMechanism.toRawExpression(result), String.class);
        }
        return result;
    }

    private static boolean isELExpression(String expression) {
        return !expression.isEmpty() && OAuth2AuthenticationMechanism.isDeferredExpression(expression);
    }

    private static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    private static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }
}

