/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import fish.payara.admingui.common.handlers.PayaraApplicationHandlers;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class DeployUtil {
    public static boolean reloadApplication(String appName, List<String> targets, HandlerContext handlerCtx) {
        try {
            String decodedName = URLDecoder.decode(appName, "UTF-8");
            List<String> clusters = TargetUtil.getClusters();
            List<String> dgs = TargetUtil.getDeploymentGroups();
            String clusterEndpoint = GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/";
            String serverEndpoint = GuiUtil.getSessionValue("REST_URL") + "/servers/server/";
            for (String targetName : targets) {
                String status;
                String endpoint;
                if (clusters.contains(targetName)) {
                    endpoint = clusterEndpoint + targetName + "/application-ref/" + decodedName;
                } else {
                    if (dgs.contains(targetName)) continue;
                    endpoint = serverEndpoint + targetName + "/application-ref/" + decodedName;
                }
                if (!Boolean.parseBoolean(status = (String)RestUtil.getAttributesMap(endpoint).get("enabled"))) continue;
                HashMap<String, Object> attrs = new HashMap<String, Object>();
                attrs.put("enabled", "false");
                RestUtil.restRequest(endpoint, attrs, "POST", null, false, true);
                attrs.put("enabled", "true");
                RestUtil.restRequest(endpoint, attrs, "POST", null, false, true);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleError(handlerCtx, ex.getMessage());
            return false;
        }
        return true;
    }

    public static List<String> getApplicationTarget(String appName, String ref) {
        ArrayList<String> targets;
        block5: {
            targets = new ArrayList<String>();
            try {
                List<String> clusters = TargetUtil.getClusters();
                for (String string : clusters) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + string + "/" + ref).keySet());
                    if (!appRefs.contains(appName)) continue;
                    targets.add(string);
                }
                List<String> servers = TargetUtil.getStandaloneInstances();
                servers.add("server");
                for (String oneServer : servers) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                    if (!appRefs.contains(appName)) continue;
                    targets.add(oneServer);
                }
                List<String> list = TargetUtil.getDeploymentGroups();
                for (String dg : list) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/deployment-groups/deployment-group/" + dg + "/" + ref).keySet());
                    if (!appRefs.contains(appName)) continue;
                    targets.add(dg);
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.appTarget") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block5;
                ex.printStackTrace();
            }
        }
        return targets;
    }

    public static List<Map<String, Object>> getRefEndpoints(String name, String ref) {
        ArrayList<Map<String, Object>> endpoints;
        block4: {
            endpoints = new ArrayList<Map<String, Object>>();
            try {
                String encodedName = URLEncoder.encode(name, "UTF-8");
                List<String> clusters = TargetUtil.getClusters();
                for (String oneCluster : clusters) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref).keySet());
                    if (!appRefs.contains(name)) continue;
                    HashMap<String, String> aMap = new HashMap<String, String>();
                    aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/clusters/cluster/" + oneCluster + "/" + ref + "/" + encodedName);
                    aMap.put("targetName", oneCluster);
                    endpoints.add(aMap);
                }
                List<String> servers = TargetUtil.getStandaloneInstances();
                servers.add("server");
                for (String oneServer : servers) {
                    ArrayList<String> appRefs = new ArrayList<String>(RestUtil.getChildMap(GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref).keySet());
                    if (!appRefs.contains(name)) continue;
                    HashMap<String, String> aMap = new HashMap<String, String>();
                    aMap.put("endpoint", GuiUtil.getSessionValue("REST_URL") + "/servers/server/" + oneServer + "/" + ref + "/" + encodedName);
                    aMap.put("targetName", oneServer);
                    endpoints.add(aMap);
                }
            }
            catch (Exception ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getRefEndpoints") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        return endpoints;
    }

    public static String getTargetEnableInfo(String appName, boolean useImage, boolean isApp) {
        String prefix = (String)GuiUtil.getSessionValue("REST_URL");
        List<String> clusters = TargetUtil.getClusters();
        List<String> standalone = TargetUtil.getStandaloneInstances();
        List<String> deploymentGroup = TargetUtil.getDeploymentGroups();
        String enabled = "true";
        int numEnabled = 0;
        int numDisabled = 0;
        int numTargets = 0;
        String ref = "application-ref";
        if (!isApp) {
            ref = "resource-ref";
        }
        if (clusters.isEmpty() && standalone.isEmpty()) {
            enabled = (String)RestUtil.getAttributesMap(prefix + "/servers/server/server/" + ref + "/" + appName).get("enabled");
            if (enabled == null) {
                enabled = (String)RestUtil.getAttributesMap(prefix + "/applications/application/" + appName).get("enabled");
            }
            if (useImage) {
                return Boolean.parseBoolean(enabled) ? "/resource/images/enabled.png" : "/resource/images/disabled.png";
            }
            return enabled;
        }
        standalone.add("server");
        List<String> targetList = new ArrayList<String>();
        try {
            targetList = DeployUtil.getApplicationTarget(URLDecoder.decode(appName, "UTF-8"), ref);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<String> instancesInDeploymentGroup = PayaraApplicationHandlers.getInstancesInDeploymentGroup(targetList);
        for (String oneTarget : targetList) {
            Boolean isValidTarget = false;
            if (clusters.contains(oneTarget)) {
                enabled = (String)RestUtil.getAttributesMap(prefix + "/clusters/cluster/" + oneTarget + "/" + ref + "/" + appName).get("enabled");
                ++numTargets;
                isValidTarget = true;
            } else if (standalone.contains(oneTarget) && !instancesInDeploymentGroup.contains(oneTarget)) {
                enabled = (String)RestUtil.getAttributesMap(prefix + "/servers/server/" + oneTarget + "/" + ref + "/" + appName).get("enabled");
                ++numTargets;
                isValidTarget = true;
            } else if (deploymentGroup.contains(oneTarget)) {
                enabled = (String)RestUtil.getAttributesMap(prefix + "/deployment-groups/deployment-group/" + oneTarget + "/" + ref + "/" + appName).get("enabled");
                ++numTargets;
                isValidTarget = true;
            }
            if (!isValidTarget.booleanValue()) continue;
            if (Boolean.parseBoolean(enabled)) {
                ++numEnabled;
                continue;
            }
            ++numDisabled;
        }
        return numTargets == 0 ? GuiUtil.getMessage("deploy.noTarget") : GuiUtil.getMessage("deploy.someEnabled", new String[]{"" + numEnabled, "" + numTargets});
    }
}

