/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.amx;

import fish.payara.admin.amx.config.AMXConfiguration;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.admin.mbeanserver.BootAMX;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="amx-boot-service")
@RunLevel(value=10)
public class AMXBootService
implements ConfigListener {
    @Inject
    AMXConfiguration config;
    @Inject
    ServiceLocator habitat;
    private boolean enabled;
    private boolean dynamic;

    @PostConstruct
    public void postConstruct() {
        this.enabled = Boolean.valueOf(this.config.getEnabled());
        if (this.enabled) {
            this.startup();
        }
    }

    private void startup() {
        BootAMX bootAMX = (BootAMX)this.habitat.getService(BootAMX.class, new Annotation[0]);
        bootAMX.bootAMX();
    }

    public void setEnabled(boolean enabled, boolean dynamic) {
        this.enabled = enabled;
        this.dynamic = dynamic;
        if (enabled && dynamic) {
            this.startup();
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        UnprocessedChangeEvents unchanged = null;
        for (PropertyChangeEvent event : events) {
            String change;
            if (!event.getPropertyName().contains("enabled") || !(change = (String)event.getNewValue()).equalsIgnoreCase("false") || !this.dynamic) continue;
            unchanged = new UnprocessedChangeEvents(new UnprocessedChangeEvent(event, "AMX can't be disabled dynamically."));
        }
        return unchanged;
    }
}

