/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.openid.OpenIdAuthenticationMechanism;
import fish.payara.security.openid.OpenIdIdentityStore;
import fish.payara.security.openid.controller.AuthenticationController;
import fish.payara.security.openid.controller.ConfigurationController;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.OriginalRequestController;
import fish.payara.security.openid.controller.ProviderMetadataContoller;
import fish.payara.security.openid.controller.StateController;
import fish.payara.security.openid.controller.TokenController;
import fish.payara.security.openid.controller.UserInfoController;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;
import org.glassfish.soteria.cdi.CdiProducer;
import org.glassfish.soteria.cdi.CdiUtils;

public class OpenIdExtension
implements Extension {
    private final List<Bean<IdentityStore>> identityStoreBeans = new ArrayList<Bean<IdentityStore>>();
    private Bean<HttpAuthenticationMechanism> authenticationMechanismBean;
    private static final Logger LOGGER = Logger.getLogger(OpenIdExtension.class.getName());

    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        this.addAnnotatedType(OpenIdAuthenticationMechanism.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(OpenIdIdentityStore.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(OpenIdContextImpl.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(NonceController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(StateController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(OriginalRequestController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(ConfigurationController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(ProviderMetadataContoller.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(AuthenticationController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(TokenController.class, manager, beforeBeanDiscovery);
        this.addAnnotatedType(UserInfoController.class, manager, beforeBeanDiscovery);
    }

    protected <T> void addAnnotatedType(Class<T> type, BeanManager manager, BeforeBeanDiscovery beforeBeanDiscovery) {
        beforeBeanDiscovery.addAnnotatedType(manager.createAnnotatedType(type), type.getName());
    }

    protected <T> void findOpenIdDefinitionAnnotation(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        ProcessBean<T> event = eventIn;
        Class beanClass = event.getBean().getBeanClass();
        Optional optionalOpenIdStore = CdiUtils.getAnnotation((BeanManager)beanManager, (Annotated)event.getAnnotated(), OpenIdAuthenticationDefinition.class);
        optionalOpenIdStore.ifPresent(definition -> {
            this.validateExtraParametersFormat((OpenIdAuthenticationDefinition)definition);
            this.logActivatedIdentityStore(OpenIdIdentityStore.class, beanClass);
            this.identityStoreBeans.add((Bean<IdentityStore>)new CdiProducer().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{Object.class, IdentityStore.class}).addToId(OpenIdIdentityStore.class).create(e -> (OpenIdIdentityStore)CDI.current().select(OpenIdIdentityStore.class, new Annotation[0]).get()));
            this.logActivatedAuthenticationMechanism(OpenIdAuthenticationMechanism.class, beanClass);
            this.authenticationMechanismBean = new CdiProducer().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class}).addToId(OpenIdAuthenticationMechanism.class).create(e -> {
                OpenIdAuthenticationMechanism mechanism = (OpenIdAuthenticationMechanism)CDI.current().select(OpenIdAuthenticationMechanism.class, new Annotation[0]).get();
                mechanism.setConfiguration((OpenIdAuthenticationDefinition)definition);
                return mechanism;
            });
        });
    }

    protected void validateExtraParametersFormat(OpenIdAuthenticationDefinition definition) {
        for (String extraParameter : definition.extraParameters()) {
            String[] parts = extraParameter.split("=");
            if (parts.length == 2) continue;
            throw new DefinitionException(OpenIdAuthenticationDefinition.class.getSimpleName() + ".extraParameters() value '" + extraParameter + "' is not of the format key=value");
        }
    }

    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.identityStoreBeans.isEmpty()) {
            this.identityStoreBeans.forEach(arg_0 -> ((AfterBeanDiscovery)afterBeanDiscovery).addBean(arg_0));
        }
        if (this.authenticationMechanismBean != null) {
            LOGGER.log(Level.FINE, "Creating OpenId Mechanism");
            afterBeanDiscovery.addBean(this.authenticationMechanismBean);
        }
    }

    private void logActivatedIdentityStore(Class<?> identityStoreClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} identity store from {1} class", new Object[]{identityStoreClass.getName(), beanClass.getName()});
    }

    private void logActivatedAuthenticationMechanism(Class<?> authenticationMechanismClass, Class<?> beanClass) {
        LOGGER.log(Level.INFO, "Activating {0} authentication mechanism from {1} class", new Object[]{authenticationMechanismClass.getName(), beanClass.getName()});
    }
}

