/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.openid.api.OpenIdState;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.StateController;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdNonce;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.AuthenticationStatus;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.common.util.StringHelper;

@ApplicationScoped
public class AuthenticationController {
    @Inject
    private StateController stateController;
    @Inject
    private NonceController nonceController;
    private static final Logger LOGGER = Logger.getLogger(AuthenticationController.class.getName());

    public AuthenticationStatus authenticateUser(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        UriBuilder authRequest = UriBuilder.fromUri((String)configuration.getProviderMetadata().getAuthorizationEndpoint()).queryParam("scope", new Object[]{configuration.getScopes()}).queryParam("response_type", new Object[]{configuration.getResponseType()}).queryParam("client_id", new Object[]{configuration.getClientId()}).queryParam("redirect_uri", new Object[]{configuration.buildRedirectURI(request)});
        OpenIdState state = new OpenIdState();
        authRequest.queryParam("state", new Object[]{state.getValue()});
        this.stateController.store(state, configuration, request, response);
        if (configuration.isUseNonce()) {
            OpenIdNonce nonce = new OpenIdNonce();
            String nonceHash = this.nonceController.getNonceHash(nonce);
            authRequest.queryParam("nonce", new Object[]{nonceHash});
            this.nonceController.store(nonce, configuration, request, response);
        }
        if (!StringHelper.isEmpty(configuration.getResponseMode())) {
            authRequest.queryParam("response_mode", new Object[]{configuration.getResponseMode()});
        }
        if (!StringHelper.isEmpty(configuration.getDisplay())) {
            authRequest.queryParam("display", new Object[]{configuration.getDisplay()});
        }
        if (!StringHelper.isEmpty(configuration.getPrompt())) {
            authRequest.queryParam("prompt", new Object[]{configuration.getPrompt()});
        }
        configuration.getExtraParameters().forEach((x$0, xva$1) -> authRequest.queryParam(x$0, new Object[]{xva$1}));
        String authUrl = authRequest.toString();
        LOGGER.log(Level.FINEST, "Redirecting for authentication to {0}", authUrl);
        try {
            response.sendRedirect(authUrl);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return AuthenticationStatus.SEND_CONTINUE;
    }
}

