/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.Scope;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class AccessTokenImpl
implements AccessToken {
    private final String token;
    private final AccessToken.Type type;
    private JWT tokenJWT;
    private Map<String, Object> claims;
    private final Long expiresIn;
    private final Scope scope;
    private final long createdAt;
    private OpenIdConfiguration configuration;

    public AccessTokenImpl(OpenIdConfiguration configuration, String tokenType, String token, Long expiresIn, String scopeValue) {
        this.configuration = configuration;
        this.token = token;
        try {
            this.tokenJWT = JWTParser.parse((String)token);
            this.claims = this.tokenJWT.getJWTClaimsSet().getClaims();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.type = AccessToken.Type.valueOf((String)tokenType.toUpperCase());
        this.expiresIn = expiresIn;
        this.createdAt = System.currentTimeMillis();
        this.scope = Scope.parse((String)scopeValue);
    }

    public JWT getTokenJWT() {
        return this.tokenJWT;
    }

    public boolean isExpired() {
        boolean expired = true;
        if (Objects.nonNull(this.expiresIn)) {
            expired = System.currentTimeMillis() + (long)this.configuration.getTokenMinValidity() > this.createdAt + this.expiresIn * 1000L;
        } else {
            Date exp = (Date)this.getClaim("exp");
            if (Objects.nonNull(exp)) {
                expired = System.currentTimeMillis() + (long)this.configuration.getTokenMinValidity() > exp.getTime();
            } else {
                throw new IllegalStateException("Missing expiration time (exp) claim in access token");
            }
        }
        return expired;
    }

    public AccessToken.Type getType() {
        return this.type;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getClaims() {
        if (this.claims == null) {
            return Collections.emptyMap();
        }
        return this.claims;
    }

    public void setClaims(Map<String, Object> claims) {
        this.claims = claims;
    }

    public Object getClaim(String key) {
        return this.getClaims().get(key);
    }

    public Long getExpirationTime() {
        return this.expiresIn;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean isEncrypted() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    public boolean isSigned() {
        return this.tokenJWT != null && this.tokenJWT instanceof EncryptedJWT;
    }

    public String toString() {
        return this.token;
    }
}

