/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.model;

import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.model.Unit;
import java.io.Serializable;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class Metric
implements Serializable {
    public final Series series;
    public final Unit unit;

    public Metric(Series series) {
        this(series, Unit.COUNT);
    }

    public Metric(Series series, Unit unit) {
        this.series = series;
        this.unit = unit;
    }

    public Metric withUnit(Unit unit) {
        return new Metric(this.series, unit);
    }

    public int hashCode() {
        return this.series.hashCode() ^ this.unit.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Metric && this.equalTo((Metric)obj);
    }

    public boolean equalTo(Metric other) {
        return this.series.equalTo(other.series) && this.unit == other.unit;
    }

    public String toString() {
        return this.series + " unit:" + this.unit.toString();
    }

    public static Metric parse(String series, String unit) {
        return new Metric(new Series(series), Unit.fromShortName(unit));
    }

    public JsonObject toJSON() {
        return Json.createObjectBuilder().add("series", this.series.toString()).add("unit", this.unit.toString()).build();
    }

    public static Metric fromJSON(JsonValue value) {
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        JsonObject obj = value.asJsonObject();
        return new Metric(new Series(obj.getString("series")), Unit.fromShortName(obj.getString("unit", "count")));
    }
}

