/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ConsumerUtil;
import java.util.HashSet;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class ConsumerManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] purgeSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumConsumers() {
        return ConsumerUtil.getNumConsumersNoChildren();
    }

    public String[] getConsumerIDs() throws MBeanException {
        int numConsumers = this.getNumConsumers();
        if (numConsumers <= 0) {
            return null;
        }
        String[] ids = new String[numConsumers];
        Iterator consumers = new HashSet(ConsumerUtil.getAllConsumersNoChildren().values()).iterator();
        int i = 0;
        while (consumers.hasNext()) {
            Consumer oneCon = (Consumer)consumers.next();
            long conID = oneCon.getConsumerUID().longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public void purge(String consumerID) throws MBeanException {
        ConsumerUID cid = null;
        try {
            cid = new ConsumerUID(Long.parseLong(consumerID));
        }
        catch (Exception e) {
            this.handleOperationException("purge", e);
        }
        Consumer con = Consumer.getConsumer(cid);
        if (!con.isDurableSubscriber()) {
            this.logger.log(8, "Purge not supported for non durable subscribers.");
            return;
        }
        if (con instanceof Subscription) {
            Subscription sub = (Subscription)con;
            try {
                sub.purge();
            }
            catch (Exception e) {
                this.handleOperationException("purge", e);
            }
        }
    }

    @Override
    public String getMBeanName() {
        return "ConsumerManagerConfig";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1068");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1069"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("consumerID", String.class.getName(), mbr.getString("MB1074"));
        purgeSignature = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[2];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1070"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("purge", mbr.getString("MB1073"), purgeSignature, Void.TYPE.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

