/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JvmOptionBag;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.v3.admin.commands.CLIUtil;
import com.sun.enterprise.v3.admin.commands.ListJvmOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.UnknownOptionsAreOperands;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;

@Service(name="delete-jvm-options")
@PerLookup
@I18n(value="delete.jvm.options")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@UnknownOptionsAreOperands
public final class DeleteJvmOptions
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="profiler", optional=true)
    Boolean fromProfiler = false;
    @Param(name="jvm_option_name", primary=true, separator=58)
    List<String> jvmOptions;
    @Inject
    Target targetService;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final StringManager lsm = StringManager.getManager(ListJvmOptions.class);
    @AccessRequired.To(value={"update"})
    private JavaConfig jc;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.updateConfigIfNeeded(this.config, this.targetService, this.target);
        this.jc = this.config.getJavaConfig();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            JavaConfig bag;
            if (this.fromProfiler.booleanValue()) {
                if (this.jc.getProfiler() == null) {
                    report.setMessage(lsm.getString("create.profiler.first"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                bag = this.jc.getProfiler();
            } else {
                bag = this.jc;
            }
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            this.deleteX((JvmOptionBag)bag, this.jvmOptions, part);
        }
        catch (Exception e) {
            String msg = e.getMessage() != null ? e.getMessage() : lsm.getStringWithDefault("delete.jvm.options.failed", "Command: delete-jvm-options failed", (Object[])new String[]{e.getMessage()});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void deleteX(JvmOptionBag bag, List<String> toRemoveOptions, ActionReport.MessagePart part) throws Exception {
        SingleConfigCode scc = bag1 -> {
            ArrayList jvmopts = new ArrayList(bag1.getJvmRawOptions());
            int orig = jvmopts.size();
            boolean removed = false;
            for (String toRemoveOption : toRemoveOptions) {
                String option = new MiniXmlParser.JvmOption((String)toRemoveOption).option;
                Iterator iter = jvmopts.iterator();
                while (iter.hasNext()) {
                    if (!new MiniXmlParser.JvmOption((String)((String)iter.next())).option.equals(option)) continue;
                    iter.remove();
                    removed = true;
                }
            }
            bag1.setJvmOptions(jvmopts);
            int now = jvmopts.size();
            if (removed) {
                part.setMessage(lsm.getString("deleted.message", (Object)(orig - now)));
            } else {
                part.setMessage(lsm.getString("no.option.deleted"));
            }
            return true;
        };
        ConfigSupport.apply((SingleConfigCode)scc, (ConfigBeanProxy)bag);
    }
}

