/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.cdi.interceptor;

import fish.payara.microprofile.metrics.MetricsService;
import fish.payara.microprofile.metrics.cdi.AnnotationReader;
import fish.payara.microprofile.metrics.cdi.MetricsAnnotationBinding;
import fish.payara.microprofile.metrics.impl.GaugeImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundConstruct;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.glassfish.internal.api.Globals;

@Interceptor
@MetricsAnnotationBinding
@Priority(value=1000)
public class MetricsInterceptor {
    private MetricRegistry registry;
    private Bean<?> bean;

    @Inject
    public MetricsInterceptor(MetricRegistry registry, @Intercepted Bean<?> bean) {
        this.registry = registry;
        this.bean = bean;
    }

    @AroundConstruct
    private Object constructorInvocation(InvocationContext context) throws Exception {
        Object target;
        MetricsService metricsService = (MetricsService)Globals.getDefaultBaseServiceLocator().getService(MetricsService.class, new Annotation[0]);
        if (metricsService.isEnabled()) {
            Class beanClass = this.bean.getBeanClass();
            this.registerMetrics(beanClass, context.getConstructor(), context.getTarget());
            target = context.proceed();
            Class type = beanClass;
            do {
                for (Method method : type.getDeclaredMethods()) {
                    if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
                    this.registerMetrics(beanClass, method, context.getTarget());
                }
            } while (!Object.class.equals(type = type.getSuperclass()));
        } else {
            target = context.proceed();
        }
        return target;
    }

    private <E extends Member & AnnotatedElement> void registerMetrics(Class<?> bean, E element, Object target) {
        MetricsInterceptor.register(bean, element, AnnotationReader.COUNTED, this.registry::counter);
        MetricsInterceptor.register(bean, element, AnnotationReader.CONCURRENT_GAUGE, this.registry::concurrentGauge);
        MetricsInterceptor.register(bean, element, AnnotationReader.METERED, this.registry::meter);
        MetricsInterceptor.register(bean, element, AnnotationReader.TIMED, this.registry::timer);
        MetricsInterceptor.register(bean, element, AnnotationReader.SIMPLY_TIMED, this.registry::simpleTimer);
        MetricsInterceptor.register(bean, element, AnnotationReader.GAUGE, (metadata, tags) -> this.registry.gauge((Metadata)metadata, new GaugeImpl((Method)element, target), (Tag)tags));
    }

    private static <E extends Member & AnnotatedElement, T extends Annotation> void register(Class<?> bean, E element, AnnotationReader<T> reader, BiConsumer<Metadata, Tag[]> register) {
        if (reader.isPresent(bean, element)) {
            register.accept(reader.metadata(bean, element), reader.tags(reader.annotation(bean, element)));
        }
    }
}

