/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.impl;

import fish.payara.microprofile.metrics.impl.Clock;
import fish.payara.microprofile.metrics.impl.ConcurrentGaugeImpl;
import fish.payara.microprofile.metrics.impl.CounterImpl;
import fish.payara.microprofile.metrics.impl.HistogramImpl;
import fish.payara.microprofile.metrics.impl.MeterImpl;
import fish.payara.microprofile.metrics.impl.MetricRegistrationListener;
import fish.payara.microprofile.metrics.impl.SimpleTimerImpl;
import fish.payara.microprofile.metrics.impl.TimerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
public class MetricRegistryImpl
implements MetricRegistry {
    private static final Logger LOGGER = Logger.getLogger(MetricRegistryImpl.class.getName());
    private final MetricRegistry.Type type;
    private final ConcurrentMap<String, MetricFamily<?>> metricsFamiliesByName = new ConcurrentHashMap();
    private final Clock clock;
    private final List<MetricRegistrationListener> listeners = new ArrayList<MetricRegistrationListener>();

    public MetricRegistryImpl(MetricRegistry.Type type) {
        this(type, Clock.defaultClock());
    }

    public MetricRegistryImpl(MetricRegistry.Type type, Clock clock) {
        this.type = type;
        this.clock = clock;
    }

    @Override
    public MetricRegistry.Type getType() {
        return this.type;
    }

    public MetricRegistryImpl addListener(MetricRegistrationListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Counter counter(String name) {
        return (Counter)this.findMetricOrCreate(name, MetricType.COUNTER, new Tag[0]);
    }

    @Override
    public Counter counter(Metadata metadata) {
        return (Counter)this.findMetricOrCreate(metadata, MetricType.COUNTER, new Tag[0]);
    }

    @Override
    public Counter counter(String name, Tag ... tags) {
        return (Counter)this.findMetricOrCreate(name, MetricType.COUNTER, tags);
    }

    @Override
    public Counter counter(Metadata metadata, Tag ... tags) {
        return (Counter)this.findMetricOrCreate(metadata, MetricType.COUNTER, tags);
    }

    @Override
    public Counter counter(MetricID metricID) {
        return (Counter)this.findMetricOrCreate(metricID.getName(), MetricType.COUNTER, metricID.getTagsAsArray());
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T object, Function<T, R> func, Tag ... tags) {
        return this.gauge(metadata, () -> (Number)func.apply(object), tags);
    }

    @Override
    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        return this.gauge(metricID.getName(), supplier, metricID.getTagsAsArray());
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T object, Function<T, R> func) {
        return this.gauge(metricID, () -> (Number)func.apply(object));
    }

    @Override
    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, Tag ... tags) {
        return this.findMetricOrCreate(metadata, MetricType.GAUGE, MetricRegistryImpl.createGauge(supplier), tags);
    }

    @Override
    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        return this.findMetricOrCreate(name, MetricType.GAUGE, MetricRegistryImpl.createGauge(supplier), tags);
    }

    private static <T extends Number> Gauge<T> createGauge(Supplier<T> supplier) {
        return supplier instanceof Gauge ? (Gauge<Number>)((Object)supplier) : () -> (Number)supplier.get();
    }

    @Override
    public <T, R extends Number> Gauge<R> gauge(String name, T object, Function<T, R> func, Tag ... tags) {
        return this.gauge(name, () -> (Number)func.apply(object), tags);
    }

    @Override
    public ConcurrentGauge concurrentGauge(String name) {
        return (ConcurrentGauge)this.findMetricOrCreate(name, MetricType.CONCURRENT_GAUGE, new Tag[0]);
    }

    @Override
    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return (ConcurrentGauge)this.findMetricOrCreate(name, MetricType.CONCURRENT_GAUGE, tags);
    }

    @Override
    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return (ConcurrentGauge)this.findMetricOrCreate(metadata, MetricType.CONCURRENT_GAUGE, new Tag[0]);
    }

    @Override
    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return (ConcurrentGauge)this.findMetricOrCreate(metadata, MetricType.CONCURRENT_GAUGE, tags);
    }

    @Override
    public ConcurrentGauge concurrentGauge(MetricID metricID) {
        return (ConcurrentGauge)this.findMetricOrCreate(metricID.getName(), MetricType.CONCURRENT_GAUGE, metricID.getTagsAsArray());
    }

    @Override
    public Histogram histogram(String name, Tag ... tags) {
        return (Histogram)this.findMetricOrCreate(name, MetricType.HISTOGRAM, tags);
    }

    @Override
    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return (Histogram)this.findMetricOrCreate(metadata, MetricType.HISTOGRAM, tags);
    }

    @Override
    public Histogram histogram(String name) {
        return (Histogram)this.findMetricOrCreate(name, MetricType.HISTOGRAM, new Tag[0]);
    }

    @Override
    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.findMetricOrCreate(metadata, MetricType.HISTOGRAM, new Tag[0]);
    }

    @Override
    public Histogram histogram(MetricID metricID) {
        return (Histogram)this.findMetricOrCreate(metricID.getName(), MetricType.HISTOGRAM, metricID.getTagsAsArray());
    }

    @Override
    public Meter meter(String name, Tag ... tags) {
        return (Meter)this.findMetricOrCreate(name, MetricType.METERED, tags);
    }

    @Override
    public Meter meter(Metadata metadata, Tag ... tags) {
        return (Meter)this.findMetricOrCreate(metadata, MetricType.METERED, tags);
    }

    @Override
    public Meter meter(String name) {
        return (Meter)this.findMetricOrCreate(name, MetricType.METERED, new Tag[0]);
    }

    @Override
    public Meter meter(Metadata metadata) {
        return (Meter)this.findMetricOrCreate(metadata, MetricType.METERED, new Tag[0]);
    }

    @Override
    public Meter meter(MetricID metricID) {
        return (Meter)this.findMetricOrCreate(metricID.getName(), MetricType.METERED, metricID.getTagsAsArray());
    }

    @Override
    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return (SimpleTimer)this.findMetricOrCreate(name, MetricType.SIMPLE_TIMER, tags);
    }

    @Override
    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return (SimpleTimer)this.findMetricOrCreate(metadata, MetricType.SIMPLE_TIMER, tags);
    }

    @Override
    public SimpleTimer simpleTimer(String name) {
        return (SimpleTimer)this.findMetricOrCreate(name, MetricType.SIMPLE_TIMER, new Tag[0]);
    }

    @Override
    public SimpleTimer simpleTimer(Metadata metadata) {
        return (SimpleTimer)this.findMetricOrCreate(metadata, MetricType.SIMPLE_TIMER, new Tag[0]);
    }

    @Override
    public SimpleTimer simpleTimer(MetricID metricID) {
        return (SimpleTimer)this.findMetricOrCreate(metricID.getName(), MetricType.SIMPLE_TIMER, metricID.getTagsAsArray());
    }

    @Override
    public Timer timer(String name, Tag ... tags) {
        return (Timer)this.findMetricOrCreate(name, MetricType.TIMER, tags);
    }

    @Override
    public Timer timer(Metadata metadata, Tag ... tags) {
        return (Timer)this.findMetricOrCreate(metadata, MetricType.TIMER, tags);
    }

    @Override
    public Timer timer(String name) {
        return (Timer)this.findMetricOrCreate(name, MetricType.TIMER, new Tag[0]);
    }

    @Override
    public Timer timer(Metadata metadata) {
        return (Timer)this.findMetricOrCreate(metadata, MetricType.TIMER, new Tag[0]);
    }

    @Override
    public Timer timer(MetricID metricID) {
        return (Timer)this.findMetricOrCreate(metricID.getName(), MetricType.TIMER, metricID.getTagsAsArray());
    }

    @Override
    public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return this.getMetric(metricID, ConcurrentGauge.class);
    }

    @Override
    public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    @Override
    public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    @Override
    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    @Override
    public Meter getMeter(MetricID metricID) {
        return this.getMetric(metricID, Meter.class);
    }

    @Override
    public SimpleTimer getSimpleTimer(MetricID metricID) {
        return this.getMetric(metricID, SimpleTimer.class);
    }

    @Override
    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    @Override
    public Metric getMetric(MetricID metricID) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        return family == null ? null : (Metric)family.get(metricID);
    }

    @Override
    public SortedSet<MetricID> getMetricIDs() {
        TreeSet<MetricID> ids = new TreeSet<MetricID>();
        for (MetricFamily e : this.metricsFamiliesByName.values()) {
            ids.addAll(e.metrics.keySet());
        }
        return ids;
    }

    @Override
    public SortedSet<String> getNames() {
        return new TreeSet<String>(this.metricsFamiliesByName.keySet());
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Gauge> getGauges(MetricFilter filter) {
        return this.findMetrics(Gauge.class, filter);
    }

    @Override
    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter filter) {
        return this.findMetrics(ConcurrentGauge.class, filter);
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Counter> getCounters(MetricFilter filter) {
        return this.findMetrics(Counter.class, filter);
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter filter) {
        return this.findMetrics(Histogram.class, filter);
    }

    @Override
    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Meter> getMeters(MetricFilter filter) {
        return this.findMetrics(Meter.class, filter);
    }

    @Override
    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter filter) {
        return this.findMetrics(SimpleTimer.class, filter);
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricID, Timer> getTimers(MetricFilter filter) {
        return this.findMetrics(Timer.class, filter);
    }

    @Override
    public Map<MetricID, Metric> getMetrics() {
        return this.findMetrics((id, metric) -> true);
    }

    @Override
    public Map<String, Metadata> getMetadata() {
        return this.metricsFamiliesByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MetricFamily)e.getValue()).metadata));
    }

    @Override
    public boolean remove(String name) {
        return this.metricsFamiliesByName.remove(name) != null;
    }

    @Override
    public boolean remove(MetricID metricID) {
        AtomicBoolean removed = new AtomicBoolean();
        this.metricsFamiliesByName.computeIfPresent(metricID.getName(), (name, family) -> {
            if (family.remove(metricID)) {
                removed.set(true);
            }
            return family.metrics.isEmpty() ? null : family;
        });
        return removed.get();
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        if (filter == MetricFilter.ALL) {
            this.metricsFamiliesByName.clear();
        }
        for (MetricFamily family : this.metricsFamiliesByName.values()) {
            for (Map.Entry entry : family.metrics.entrySet()) {
                if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
                this.remove((MetricID)entry.getKey());
            }
        }
    }

    private <T extends Metric> SortedMap<MetricID, T> findMetrics(Class<T> metricClass, MetricFilter filter) {
        return this.findMetrics((id, metric) -> metricClass.isInstance(metric) && filter.matches(id, metric));
    }

    private <T extends Metric> SortedMap<MetricID, T> findMetrics(MetricFilter filter) {
        TreeMap matches = new TreeMap();
        for (MetricFamily family : this.metricsFamiliesByName.values()) {
            for (Map.Entry entry : family.metrics.entrySet()) {
                if (!filter.matches((MetricID)entry.getKey(), (Metric)entry.getValue())) continue;
                matches.put(entry.getKey(), (Metric)entry.getValue());
            }
        }
        return matches;
    }

    private <T extends Metric> T findMetricOrCreate(String name, MetricType metricType, Tag ... tags) {
        return this.findMetricOrCreate(name, metricType, (T)null, tags);
    }

    private <T extends Metric> T findMetricOrCreate(String name, MetricType metricType, T metric, Tag ... tags) {
        MetricRegistryImpl.checkNameIsNotNullOrEmpty(name);
        Metadata metadata = Metadata.builder().withName(name).withType(metricType).withDisplayName("").build();
        return this.findMetricOrCreate(metadata, true, metric, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, MetricType metricType, Tag ... tags) {
        return this.findMetricOrCreate(metadata, metricType, (T)null, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, MetricType metricType, T metric, Tag ... tags) {
        return this.findMetricOrCreate(MetricRegistryImpl.withType(metadata, metricType), false, metric, tags);
    }

    private <T extends Metric> T findMetricOrCreate(Metadata metadata, boolean useExistingMetadata, T metric, Tag ... tags) {
        MetricID metricID = new MetricID(metadata.getName(), tags);
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        if (family == null) {
            return this.register(metadata, useExistingMetadata, metric, tags);
        }
        Object existing = family.get(metricID);
        if (existing == null) {
            MetricRegistryImpl.checkSameType(metricID.getName(), metadata, family.metadata);
            return this.register(metadata, useExistingMetadata, metric, tags);
        }
        if (useExistingMetadata && metadata.getType() != family.metadata.getType() || !useExistingMetadata && !metadata.equals(family.metadata)) {
            throw new IllegalArgumentException(String.format("Tried to lookup a metric with conflicting metadata, looup is %s, existing is %s", metadata.toString(), family.metadata.toString()));
        }
        return existing;
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        MetricRegistryImpl.checkNameIsNotNullOrEmpty(name);
        return this.register(Metadata.builder().withName(name).build(), true, metric, new Tag[0]);
    }

    @Override
    public <T extends Metric> T register(Metadata metadata, T metric) throws IllegalArgumentException {
        return this.register(metadata, false, metric, new Tag[0]);
    }

    @Override
    public <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) throws IllegalArgumentException {
        return this.register(metadata, false, metric, tags);
    }

    private <T extends Metric> T register(Metadata metadata, boolean useExistingMetadata, T metric, Tag ... tags) {
        Metadata existingMetadata;
        if (metadata.getTypeRaw() == MetricType.INVALID) {
            metadata = MetricRegistryImpl.withType(metadata, MetricType.from(metric.getClass()));
        }
        String name = metadata.getName();
        MetricRegistryImpl.checkNameIsNotNullOrEmpty(name);
        if (useExistingMetadata && (existingMetadata = this.getMetadata(name)) != null) {
            MetricRegistryImpl.checkSameType(name, metadata, existingMetadata);
            metadata = existingMetadata;
        }
        Metadata newMetadata = metadata;
        Metric newMetric = metric != null ? metric : this.createMetricInstance(newMetadata);
        MetricFamily family = this.metricsFamiliesByName.computeIfAbsent(name, key -> new MetricFamily(newMetadata));
        MetricID metricID = new MetricID(name, tags);
        if (family.metadata != newMetadata) {
            MetricRegistryImpl.checkReusableMetadata(name, newMetadata, family.metadata);
        }
        Metric current = family.metrics.computeIfAbsent(metricID, key -> newMetric);
        this.notifyRegistrationListeners(metricID);
        return (T)current;
    }

    private void notifyRegistrationListeners(MetricID metricID) {
        for (MetricRegistrationListener l : this.listeners) {
            try {
                l.onRegistration(metricID, this);
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.WARNING, "Registration listener threw exception:", ex);
            }
        }
    }

    private static void checkNameIsNotNullOrEmpty(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Metric name must not be null or empty");
        }
    }

    private static void checkReusableMetadata(String name, Metadata newMetadata, Metadata existingMetadata) {
        MetricRegistryImpl.checkSameType(name, newMetadata, existingMetadata);
        if (!existingMetadata.equals(newMetadata)) {
            throw new IllegalArgumentException(String.format("Metadata ['%s'] already registered, does not match provided ['%s']", existingMetadata.toString(), newMetadata.toString()));
        }
    }

    private static void checkSameType(String name, Metadata newMetadata, Metadata existingMetadata) {
        if (existingMetadata.getTypeRaw() != newMetadata.getTypeRaw()) {
            throw new IllegalArgumentException(String.format("Metric ['%s'] type['%s'] does not match with existing type['%s']", name, newMetadata.getType(), existingMetadata.getType()));
        }
    }

    private Metric createMetricInstance(Metadata metadata) {
        String name = metadata.getName();
        switch (metadata.getTypeRaw()) {
            case COUNTER: {
                return new CounterImpl();
            }
            case CONCURRENT_GAUGE: {
                return new ConcurrentGaugeImpl(this.clock);
            }
            case GAUGE: {
                throw new IllegalArgumentException(String.format("Unsupported operation for Gauge ['%s']", name));
            }
            case METERED: {
                return new MeterImpl();
            }
            case HISTOGRAM: {
                return new HistogramImpl();
            }
            case TIMER: {
                return new TimerImpl(this.clock);
            }
            case SIMPLE_TIMER: {
                return new SimpleTimerImpl(this.clock);
            }
        }
        throw new IllegalStateException("Invalid metric type : " + (Object)((Object)metadata.getTypeRaw()));
    }

    @Override
    public <T extends Metric> T getMetric(MetricID metricID, Class<T> ofType) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(metricID.getName());
        if (family == null) {
            return null;
        }
        Object metric = family.get(metricID);
        if (metric != null && !ofType.isAssignableFrom(metric.getClass())) {
            throw new IllegalArgumentException("Invalid metric type : " + ofType);
        }
        return metric;
    }

    @Override
    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.findMetrics((metricID, metric) -> filter.matches(metricID, metric) && ofType.isAssignableFrom(metric.getClass()));
    }

    @Override
    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        return this.findMetrics(filter);
    }

    @Override
    public Metadata getMetadata(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? null : family.metadata;
    }

    public Set<MetricID> getMetricsIDs(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? Collections.emptySet() : Collections.unmodifiableSet(family.metrics.keySet());
    }

    public Map<MetricID, Metric> getMetrics(String name) {
        MetricFamily family = (MetricFamily)this.metricsFamiliesByName.get(name);
        return family == null ? Collections.emptyMap() : Collections.unmodifiableMap(family.metrics);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (Map.Entry family : this.metricsFamiliesByName.entrySet()) {
            str.append((String)family.getKey()).append(": ").append(((MetricFamily)family.getValue()).metadata).append('\n');
            for (Map.Entry entry : ((MetricFamily)family.getValue()).metrics.entrySet()) {
                str.append('\t').append(entry.getKey()).append(": ").append(MetricRegistryImpl.toString((Metric)entry.getValue())).append('\n');
            }
        }
        return str.toString();
    }

    private static String toString(Metric metric) {
        if (MetricRegistryImpl.isLambda(metric) && metric instanceof Gauge) {
            return "Gauge[" + ((Gauge)metric).getValue() + "]";
        }
        return metric.toString();
    }

    public static boolean isLambda(Object obj) {
        return obj.getClass().toString().contains("$$Lambda$");
    }

    private static Metadata withType(Metadata metadata, MetricType type) {
        if (type == metadata.getTypeRaw()) {
            return metadata;
        }
        return Metadata.builder(metadata).withType(type).build();
    }

    static final class MetricFamily<T extends Metric> {
        final Metadata metadata;
        final ConcurrentMap<MetricID, T> metrics = new ConcurrentHashMap<MetricID, T>();

        MetricFamily(Metadata metadata) {
            this.metadata = metadata;
        }

        boolean remove(MetricID metricID) {
            return this.metrics.remove(metricID) != null;
        }

        T get(MetricID metricID) {
            return (T)((Metric)this.metrics.get(metricID));
        }
    }
}

