/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.metrics.jmx;

import fish.payara.microprofile.metrics.jmx.MBeanCounterImpl;
import fish.payara.microprofile.metrics.jmx.MBeanExpression;
import fish.payara.microprofile.metrics.jmx.MBeanGuageImpl;
import fish.payara.microprofile.metrics.jmx.MBeanMetadata;
import fish.payara.microprofile.metrics.jmx.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.jvnet.hk2.annotations.Service;

@Service
public class MBeanMetadataHelper {
    public static final String SPECIFIER = "%s";
    public static final String KEY = "${key}";
    public static final String ATTRIBUTE = "${attribute}";
    public static final String SUB_ATTRIBUTE = "${subattribute}";
    public static final String ATTRIBUTE_SEPARATOR = "/";
    public static final String SUB_ATTRIBUTE_SEPARATOR = "#";
    private static final Logger LOGGER = Logger.getLogger(MBeanMetadataHelper.class.getName());

    public List<MBeanMetadata> registerMetadata(MetricRegistry metricRegistry, List<MBeanMetadata> metadataList, boolean isRetry) {
        if (!metricRegistry.getNames().isEmpty() && !isRetry) {
            metricRegistry.removeMatching(MetricFilter.ALL);
        }
        List<MBeanMetadata> unresolvedMetadataList = this.resolveDynamicMetadata(metadataList);
        for (MBeanMetadata beanMetadata : metadataList) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (XmlTag tag : beanMetadata.getTags()) {
                tags.add(new Tag(tag.getName(), tag.getValue()));
            }
            try {
                Metric type;
                if (metricRegistry.getNames().contains(beanMetadata.getName()) && metricRegistry.getMetricIDs().contains(new MetricID(beanMetadata.getName(), tags.toArray(new Tag[tags.size()])))) continue;
                MBeanExpression mBeanExpression = new MBeanExpression(beanMetadata.getMBean());
                switch (beanMetadata.getTypeRaw()) {
                    case COUNTER: {
                        type = new MBeanCounterImpl(mBeanExpression);
                        break;
                    }
                    case GAUGE: {
                        type = new MBeanGuageImpl(mBeanExpression);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported type : " + beanMetadata);
                    }
                }
                metricRegistry.register(beanMetadata, type, tags.toArray(new Tag[tags.size()]));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return unresolvedMetadataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MBeanMetadata> resolveDynamicMetadata(List<MBeanMetadata> metadataList) {
        ArrayList<MBeanMetadata> unresolvedMetadataList = new ArrayList<MBeanMetadata>();
        ArrayList<MBeanMetadata> resolvedMetadataList = new ArrayList<MBeanMetadata>();
        ArrayList<MBeanMetadata> removedMetadataList = new ArrayList<MBeanMetadata>(metadataList.size());
        for (MBeanMetadata metadata : metadataList) {
            if (!metadata.isValid()) {
                removedMetadataList.add(metadata);
                continue;
            }
            if (!metadata.getMBean().contains(SPECIFIER) && !metadata.getMBean().contains(KEY) && !metadata.getMBean().contains(ATTRIBUTE) && !metadata.getMBean().contains(SUB_ATTRIBUTE)) continue;
            try {
                MBeanExpression mBeanExpression;
                if (metadata.getMBean().contains(SPECIFIER) || metadata.getMBean().contains(KEY)) {
                    mBeanExpression = new MBeanExpression(metadata.getMBean().replace(SPECIFIER, "*").replace(KEY, "*"));
                    String dynamicKey = mBeanExpression.findDynamicKey();
                    Set<ObjectName> mBeanObjects = mBeanExpression.queryNames(null);
                    if (mBeanObjects.isEmpty()) {
                        unresolvedMetadataList.add(metadata);
                        LOGGER.log(Level.INFO, "{0} does not correspond to any MBeans", metadata.getMBean());
                    } else if (metadata.isDynamic()) {
                        unresolvedMetadataList.add(metadata);
                    }
                    for (ObjectName objName : mBeanObjects) {
                        String dynamicValue = objName.getKeyPropertyList().get(dynamicKey);
                        resolvedMetadataList.addAll(MBeanMetadataHelper.loadAttribute(objName, mBeanExpression, metadata, dynamicValue));
                    }
                    continue;
                }
                mBeanExpression = new MBeanExpression(metadata.getMBean());
                ObjectName objName = mBeanExpression.getObjectName();
                if (objName == null) {
                    unresolvedMetadataList.add(metadata);
                    LOGGER.log(Level.INFO, "{0} does not correspond to any MBeans", metadata.getMBean());
                } else if (metadata.isDynamic()) {
                    unresolvedMetadataList.add(metadata);
                }
                resolvedMetadataList.addAll(MBeanMetadataHelper.loadAttribute(objName, mBeanExpression, metadata, null));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.SEVERE, ex, () -> metadata.getMBean() + " is invalid");
            }
            finally {
                removedMetadataList.add(metadata);
            }
        }
        metadataList.removeAll(removedMetadataList);
        metadataList.addAll(resolvedMetadataList);
        return unresolvedMetadataList;
    }

    private static List<MBeanMetadata> loadAttribute(ObjectName objName, MBeanExpression mBeanExpression, MBeanMetadata metadata, String key) {
        ArrayList<MBeanMetadata> metadataList = new ArrayList<MBeanMetadata>();
        if (ATTRIBUTE.equals(mBeanExpression.getAttributeName())) {
            List<MBeanAttributeInfo> attributes = mBeanExpression.queryAttributes(objName);
            for (MBeanAttributeInfo attribute : attributes) {
                String attributeName = attribute.getName();
                metadataList.addAll(MBeanMetadataHelper.loadSubAttribute(objName, mBeanExpression, metadata, key, attributeName, true));
            }
        } else {
            String attributeName = mBeanExpression.getAttributeName();
            metadataList.addAll(MBeanMetadataHelper.loadSubAttribute(objName, mBeanExpression, metadata, key, attributeName, false));
        }
        return metadataList;
    }

    private static List<MBeanMetadata> loadSubAttribute(ObjectName objName, MBeanExpression mBeanExpression, MBeanMetadata metadata, String key, String attribute, boolean isDynamicAttribute) {
        ArrayList<MBeanMetadata> metadataList = new ArrayList<MBeanMetadata>();
        String exp = objName.getCanonicalName();
        String subAttribute = mBeanExpression.getSubAttributeName();
        if (subAttribute != null) {
            if (SUB_ATTRIBUTE.equals(subAttribute)) {
                Object obj = mBeanExpression.querySubAttributes(objName, attribute);
                if (obj instanceof CompositeDataSupport) {
                    CompositeDataSupport compositeData = (CompositeDataSupport)obj;
                    MetadataBuilder newMetadataBuilder = Metadata.builder(metadata);
                    for (String subAttrResolvedName : compositeData.getCompositeType().keySet()) {
                        subAttribute = subAttrResolvedName;
                        if ("description".equals(subAttribute) && compositeData.get(subAttribute) instanceof String && metadata.description().isPresent()) {
                            newMetadataBuilder = newMetadataBuilder.withDescription((String)compositeData.get(subAttribute));
                            continue;
                        }
                        if ("name".equals(subAttribute) && compositeData.get(subAttribute) instanceof String && metadata.getDisplayName() == null) {
                            newMetadataBuilder = newMetadataBuilder.withDisplayName((String)compositeData.get(subAttribute));
                            continue;
                        }
                        if (!"unit".equals(subAttribute) || !(compositeData.get(subAttribute) instanceof String) || !"none".equals(metadata.unit().orElse("none"))) continue;
                        newMetadataBuilder = newMetadataBuilder.withUnit((String)compositeData.get(subAttribute));
                    }
                    MBeanMetadata newMbeanMetadata = new MBeanMetadata(newMetadataBuilder.build());
                    newMbeanMetadata.addTags(metadata.getTags());
                    metadataList.add(MBeanMetadataHelper.createMetadata(newMbeanMetadata, exp, key, attribute, subAttribute));
                }
            } else if (isDynamicAttribute) {
                CompositeDataSupport compositeData;
                Object obj = mBeanExpression.querySubAttributes(objName, attribute);
                if (obj instanceof CompositeDataSupport && (compositeData = (CompositeDataSupport)obj).containsKey(subAttribute) && compositeData.get(subAttribute) instanceof Number) {
                    metadataList.add(MBeanMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute));
                }
            } else {
                metadataList.add(MBeanMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute));
            }
        } else {
            metadataList.add(MBeanMetadataHelper.createMetadata(metadata, exp, key, attribute, subAttribute));
        }
        return metadataList;
    }

    private static MBeanMetadata createMetadata(MBeanMetadata metadata, String exp, String key, String attribute, String subAttribute) {
        StringBuilder builder = new StringBuilder();
        builder.append(exp);
        builder.append(ATTRIBUTE_SEPARATOR);
        builder.append(attribute);
        if (subAttribute != null) {
            builder.append(SUB_ATTRIBUTE_SEPARATOR);
            builder.append(subAttribute);
        }
        MBeanMetadata newMetaData = new MBeanMetadata(builder.toString(), MBeanMetadataHelper.formatMetadata(metadata.getName(), key, attribute, subAttribute), MBeanMetadataHelper.formatMetadata(Objects.nonNull(metadata.getDisplayName()) ? metadata.getDisplayName() : metadata.getName(), key, attribute, subAttribute), MBeanMetadataHelper.formatMetadata(metadata.description().isPresent() ? metadata.getDescription() : metadata.getName(), key, attribute, subAttribute), metadata.getTypeRaw(), metadata.unit().orElse(null));
        for (XmlTag oldTag : metadata.getTags()) {
            XmlTag newTag = new XmlTag();
            newTag.setName(MBeanMetadataHelper.formatMetadata(oldTag.getName(), key, attribute, subAttribute));
            newTag.setValue(MBeanMetadataHelper.formatMetadata(oldTag.getValue(), key, attribute, subAttribute));
            newMetaData.getTags().add(newTag);
        }
        return newMetaData;
    }

    private static String formatMetadata(String metadata, String dynamicValue, String attributeName, String subAttributeName) {
        if (dynamicValue != null && metadata.contains(SPECIFIER)) {
            metadata = metadata.replace(SPECIFIER, dynamicValue);
        }
        if (dynamicValue != null && metadata.contains(KEY)) {
            metadata = metadata.replace(KEY, dynamicValue);
        }
        if (attributeName != null && metadata.contains(ATTRIBUTE)) {
            metadata = metadata.replace(ATTRIBUTE, attributeName);
        }
        if (subAttributeName != null && metadata.contains(SUB_ATTRIBUTE)) {
            metadata = metadata.replace(SUB_ATTRIBUTE, subAttributeName);
        }
        return metadata;
    }
}

